/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.generic;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.Pkcs11SignatureToken;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.AuthProvider;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.UUID;
import javax.security.auth.login.LoginException;
import lu.nowina.nexu.CancelledOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.SunPKCS11;

public class Pkcs11SignatureTokenAdapter
extends Pkcs11SignatureToken {
    private static final Logger logger = LoggerFactory.getLogger(Pkcs11SignatureTokenAdapter.class.getName());
    private Provider provider;
    private final int slotListIndex;

    public Pkcs11SignatureTokenAdapter(File pkcs11lib, PasswordInputCallback callback, int terminalIndex) {
        super(pkcs11lib.getAbsolutePath(), callback, terminalIndex);
        this.slotListIndex = terminalIndex;
        logger.info("Lib " + pkcs11lib.getAbsolutePath());
    }

    @Override
    public void close() {
        if (this.provider != null) {
            try {
                if (this.provider instanceof AuthProvider) {
                    ((AuthProvider)this.provider).logout();
                }
            }
            catch (LoginException e) {
                LOG.error("LoginException on logout of '" + this.provider.getName() + "'", e);
            }
            this.provider.clear();
            try {
                Security.removeProvider(this.provider.getName());
            }
            catch (SecurityException e) {
                LOG.error("Unable to remove provider '" + this.provider.getName() + "'", e);
            }
            finally {
                this.provider = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Provider getProvider() {
        if (this.provider != null) return this.provider;
        String aPKCS11LibraryFileName = this.getPkcs11Path();
        aPKCS11LibraryFileName = this.escapePath(aPKCS11LibraryFileName);
        StringBuilder pkcs11Config = new StringBuilder();
        pkcs11Config.append("name = SmartCard").append(UUID.randomUUID().toString()).append("\n");
        pkcs11Config.append("library = \"").append(aPKCS11LibraryFileName).append("\"").append("\n");
        pkcs11Config.append("slotListIndex = ").append(this.getSlotListIndex());
        String configString = pkcs11Config.toString();
        LOG.debug("PKCS11 Config : \n{}", (Object)configString);
        try (ByteArrayInputStream confStream = new ByteArrayInputStream(configString.getBytes("ISO-8859-1"));){
            SunPKCS11 sunPKCS11 = new SunPKCS11((InputStream)confStream);
            Security.addProvider(sunPKCS11);
            Provider provider = this.provider = sunPKCS11;
            return provider;
        }
        catch (Exception e) {
            throw new DSSException("Unable to instantiate SunPKCS11", e);
        }
    }

    protected String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    protected int getSlotListIndex() {
        return this.slotListIndex;
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        try {
            return super.getKeys();
        }
        catch (Exception e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if ("CKR_CANCEL".equals(t.getMessage()) || "CKR_FUNCTION_CANCELED".equals(t.getMessage())) {
                    throw new CancelledOperationException(e);
                }
                if (!(t instanceof CancelledOperationException)) continue;
                throw (CancelledOperationException)t;
            }
            throw e;
        }
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, DSSPrivateKeyEntry keyEntry) throws DSSException {
        try {
            return super.sign(toBeSigned, digestAlgorithm, mgf, keyEntry);
        }
        catch (Exception e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if ("CKR_CANCEL".equals(t.getMessage()) || "CKR_FUNCTION_CANCELED".equals(t.getMessage())) {
                    throw new CancelledOperationException(e);
                }
                if (!(t instanceof CancelledOperationException)) continue;
                throw (CancelledOperationException)t;
            }
            throw e;
        }
    }
}

