/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.generic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import lu.nowina.nexu.NexuException;
import lu.nowina.nexu.NexuLauncher;
import lu.nowina.nexu.api.AppConfig;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.Feedback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugHelper {
    private static final String DEBUG_FILE_NAME = "nexu.debug";
    private static final String LOG_FILE_NAME = "nexu.log";
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugHelper.class);

    Feedback collectDebugData(Throwable throwable) {
        Exception exception = throwable instanceof Exception ? (Exception)throwable : new NexuException(throwable);
        Feedback feedback = new Feedback(exception);
        feedback.setNexuVersion(this.getConfig().getApplicationVersion());
        feedback.setInfo(EnvironmentInfo.buildFromSystemProperties(this.getProperties()));
        return feedback;
    }

    Path buildDebugFile() throws IOException {
        File debugFile = null;
        Path debugFilePath = null;
        Path existingLogPath = Paths.get(this.getConfig().getNexuHome().getAbsolutePath(), LOG_FILE_NAME);
        debugFilePath = existingLogPath.toFile().exists() ? Files.copy(existingLogPath, Paths.get(this.getConfig().getNexuHome().getAbsolutePath(), DEBUG_FILE_NAME), StandardCopyOption.REPLACE_EXISTING) : Paths.get(this.getConfig().getNexuHome().getAbsolutePath(), DEBUG_FILE_NAME);
        debugFile = debugFilePath.toFile();
        debugFile.createNewFile();
        return debugFilePath;
    }

    File appendFeedbackData(Path debugFilePath, Feedback feedback) throws JAXBException, IOException {
        File debugFile = null;
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Feedback.class});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        debugFile = debugFilePath.toFile();
        try (FileWriter fw = new FileWriter(debugFile, true);){
            marshaller.marshal((Object)feedback, (Writer)fw);
        }
        return debugFile;
    }

    void showDebugFileInExplorer(Path debugFilePath, Feedback feedback) {
        String os = feedback.getInfo().getOs().name();
        if (os.equalsIgnoreCase("windows")) {
            try {
                this.showFileInWindows(debugFilePath);
            }
            catch (IOException e) {
                LOGGER.warn("Error while trying to open Windows file browser: {}", (Object)e.getMessage());
            }
        } else if (os.equalsIgnoreCase("linux")) {
            try {
                this.showFileInLinux(debugFilePath);
            }
            catch (IOException e) {
                LOGGER.warn("Error while trying to open Linux file browser: {}", (Object)e.getMessage());
            }
        }
    }

    private void showFileInWindows(Path debugFilePath) throws IOException {
        Runtime.getRuntime().exec(String.format("explorer.exe /select,%s", debugFilePath));
    }

    private void showFileInLinux(Path debugFilePath) throws IOException {
        Process process = Runtime.getRuntime().exec("xdg-mime query default inode/directory");
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String os = stdInput.readLine().split("\\.")[0];
        Runtime.getRuntime().exec(String.format("%s %s", os, debugFilePath));
    }

    public Feedback processError(Throwable throwable) throws IOException, JAXBException {
        Feedback feedback = this.collectDebugData(throwable);
        Path debugFilePath = this.buildDebugFile();
        File debugFile = this.appendFeedbackData(debugFilePath, feedback);
        this.showDebugFileInExplorer(debugFile.toPath(), feedback);
        return feedback;
    }

    AppConfig getConfig() {
        return NexuLauncher.getConfig();
    }

    Properties getProperties() {
        return System.getProperties();
    }

    String getDebugFileName() {
        return DEBUG_FILE_NAME;
    }
}

