/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow.operation;

import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.util.Iterator;
import java.util.List;
import lu.nowina.nexu.CancelledOperationException;
import lu.nowina.nexu.api.CertificateFilter;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.flow.operation.AbstractCompositeOperation;
import lu.nowina.nexu.flow.operation.CoreOperationStatus;
import lu.nowina.nexu.view.core.UIOperation;

public class SelectPrivateKeyOperation
extends AbstractCompositeOperation<DSSPrivateKeyEntry> {
    private SignatureTokenConnection token;
    private NexuAPI api;
    private Product product;
    private ProductAdapter productAdapter;
    private CertificateFilter certificateFilter;
    private String keyFilter;

    @Override
    public void setParams(Object ... params) {
        try {
            this.token = (SignatureTokenConnection)params[0];
            this.api = (NexuAPI)params[1];
            if (params.length > 2) {
                this.product = (Product)params[2];
            }
            if (params.length > 3) {
                this.productAdapter = (ProductAdapter)params[3];
            }
            if (params.length > 4) {
                this.certificateFilter = (CertificateFilter)params[4];
            }
            if (params.length > 5) {
                this.keyFilter = (String)params[5];
            }
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Expected parameters: SignatureTokenConnection, NexuAPI, Product (optional), ProductAdapter (optional), CertificateFilter (optional), key filter (optional)");
        }
    }

    @Override
    public OperationResult<DSSPrivateKeyEntry> perform() {
        List<DSSPrivateKeyEntry> keys;
        try {
            keys = this.productAdapter != null && this.product != null && this.productAdapter.supportCertificateFilter(this.product) && this.certificateFilter != null ? this.productAdapter.getKeys(this.token, this.certificateFilter) : this.token.getKeys();
        }
        catch (CancelledOperationException e) {
            return new OperationResult<DSSPrivateKeyEntry>(BasicOperationStatus.USER_CANCEL);
        }
        DSSPrivateKeyEntry key = null;
        Iterator<DSSPrivateKeyEntry> it = keys.iterator();
        while (it.hasNext()) {
            DSSPrivateKeyEntry e = it.next();
            if (!"CN=Token Signing Public Key".equals(e.getCertificate().getCertificate().getIssuerDN().getName())) continue;
            it.remove();
        }
        if (keys.isEmpty()) {
            return new OperationResult<DSSPrivateKeyEntry>(CoreOperationStatus.NO_KEY);
        }
        if (keys.size() == 1) {
            key = keys.get(0);
            if (this.keyFilter != null && !key.getCertificate().getDSSIdAsString().equals(this.keyFilter)) {
                return new OperationResult<DSSPrivateKeyEntry>(CoreOperationStatus.CANNOT_SELECT_KEY);
            }
            return new OperationResult<DSSPrivateKeyEntry>(key);
        }
        if (this.keyFilter != null) {
            for (DSSPrivateKeyEntry k : keys) {
                if (!k.getCertificate().getDSSIdAsString().equals(this.keyFilter)) continue;
                key = k;
                break;
            }
            if (key == null) {
                return new OperationResult<DSSPrivateKeyEntry>(CoreOperationStatus.CANNOT_SELECT_KEY);
            }
        } else if (this.api.getAppConfig().isEnablePopUps()) {
            OperationResult op = this.operationFactory.getOperation(UIOperation.class, "/fxml/key-selection.fxml", new Object[]{keys, this.api.getAppConfig().getApplicationName(), this.api.getAppConfig().isDisplayBackButton()}).perform();
            if (op.getStatus().equals(CoreOperationStatus.BACK)) {
                return new OperationResult<DSSPrivateKeyEntry>(CoreOperationStatus.BACK);
            }
            if (op.getStatus().equals(BasicOperationStatus.USER_CANCEL)) {
                return new OperationResult<DSSPrivateKeyEntry>(BasicOperationStatus.USER_CANCEL);
            }
            key = (DSSPrivateKeyEntry)op.getResult();
            if (key == null) {
                return new OperationResult<DSSPrivateKeyEntry>(CoreOperationStatus.NO_KEY_SELECTED);
            }
        } else {
            return new OperationResult<DSSPrivateKeyEntry>(CoreOperationStatus.CANNOT_SELECT_KEY);
        }
        return new OperationResult<DSSPrivateKeyEntry>(key);
    }
}

