/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow.operation;

import eu.europa.esig.dss.token.MSCAPISignatureToken;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.token.mocca.MOCCASignatureTokenConnection;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lu.nowina.nexu.api.DetectedCard;
import lu.nowina.nexu.api.Match;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.ScAPI;
import lu.nowina.nexu.api.TokenId;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.flow.operation.AbstractCompositeOperation;
import lu.nowina.nexu.flow.operation.CoreOperationStatus;
import lu.nowina.nexu.flow.operation.TokenOperationResultKey;
import lu.nowina.nexu.generic.ConnectionInfo;
import lu.nowina.nexu.generic.GenericCardAdapter;
import lu.nowina.nexu.generic.MOCCASignatureTokenConnectionAdapter;
import lu.nowina.nexu.generic.Pkcs11SignatureTokenAdapter;
import lu.nowina.nexu.generic.SCInfo;
import lu.nowina.nexu.model.Pkcs11Params;
import lu.nowina.nexu.view.core.UIOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTokenOperation
extends AbstractCompositeOperation<Map<TokenOperationResultKey, Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateTokenOperation.class.getName());
    private NexuAPI api;
    private List<Match> matchingProductAdapters;

    @Override
    public void setParams(Object ... params) {
        try {
            this.api = (NexuAPI)params[0];
            this.matchingProductAdapters = (List)params[1];
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Expected parameters: NexuAPI, List of Match");
        }
    }

    @Override
    public OperationResult<Map<TokenOperationResultKey, Object>> perform() {
        LOG.info(this.matchingProductAdapters.size() + " matching product adapters");
        if (!this.matchingProductAdapters.isEmpty()) {
            return this.createTokenAuto();
        }
        boolean advanced = false;
        if (this.api.getAppConfig().isAdvancedModeAvailable() && this.api.getAppConfig().isEnablePopUps()) {
            LOG.info("Advanced mode available");
            OperationResult result = this.operationFactory.getOperation(UIOperation.class, "/fxml/unsupported-product.fxml", new Object[]{this.api.getAppConfig().getApplicationName()}).perform();
            if (result.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                advanced = true;
            }
        }
        if (advanced) {
            LOG.info("Advanced mode");
            return this.createTokenAdvanced();
        }
        if (this.api.getAppConfig().isEnablePopUps()) {
            this.operationFactory.getOperation(UIOperation.class, "/fxml/message.fxml", "unsuported.product.message", this.api.getAppConfig().getApplicationName()).perform();
        }
        return new OperationResult<Map<TokenOperationResultKey, Object>>(CoreOperationStatus.UNSUPPORTED_PRODUCT);
    }

    private OperationResult<Map<TokenOperationResultKey, Object>> createTokenAuto() {
        Match match = this.matchingProductAdapters.get(0);
        Product supportedProduct = match.getProduct();
        ProductAdapter adapter = match.getAdapter();
        SignatureTokenConnection connect = adapter.supportMessageDisplayCallback(supportedProduct) ? adapter.connect(this.api, supportedProduct, this.display.getPasswordInputCallback(), this.display.getMessageDisplayCallback()) : adapter.connect(this.api, supportedProduct, this.display.getPasswordInputCallback());
        if (connect == null) {
            LOG.error("No connect returned");
            return new OperationResult<Map<TokenOperationResultKey, Object>>(CoreOperationStatus.NO_TOKEN);
        }
        TokenId tokenId = this.api.registerTokenConnection(connect);
        if (tokenId == null) {
            LOG.error("Received null TokenId after registration");
            return new OperationResult<Map<TokenOperationResultKey, Object>>(CoreOperationStatus.NO_TOKEN_ID);
        }
        HashMap<TokenOperationResultKey, Object> map = new HashMap<TokenOperationResultKey, Object>();
        map.put(TokenOperationResultKey.TOKEN_ID, tokenId);
        map.put(TokenOperationResultKey.ADVANCED_CREATION, false);
        map.put(TokenOperationResultKey.SELECTED_PRODUCT, supportedProduct);
        map.put(TokenOperationResultKey.SELECTED_PRODUCT_ADAPTER, adapter);
        return new OperationResult<Map<TokenOperationResultKey, Object>>(map);
    }

    private OperationResult<Map<TokenOperationResultKey, Object>> createTokenAdvanced() {
        TokenId tokenId;
        LOG.info("Advanced mode selected");
        OperationResult result = this.operationFactory.getOperation(UIOperation.class, "/fxml/api-selection.fxml", new Object[]{this.api.getAppConfig().getApplicationName()}).perform();
        if (result.getStatus().equals(BasicOperationStatus.USER_CANCEL)) {
            return new OperationResult<Map<TokenOperationResultKey, Object>>(BasicOperationStatus.USER_CANCEL);
        }
        HashMap<TokenOperationResultKey, Object> map = new HashMap<TokenOperationResultKey, Object>();
        map.put(TokenOperationResultKey.ADVANCED_CREATION, true);
        map.put(TokenOperationResultKey.SELECTED_API, result.getResult());
        DetectedCard selectedCard = this.api.detectCards().get(0);
        map.put(TokenOperationResultKey.SELECTED_PRODUCT, selectedCard);
        switch ((ScAPI)((Object)result.getResult())) {
            case MOCCA: {
                tokenId = this.api.registerTokenConnection(new MOCCASignatureTokenConnectionAdapter(new MOCCASignatureTokenConnection(this.display.getPasswordInputCallback()), this.api, selectedCard));
                break;
            }
            case MSCAPI: {
                tokenId = this.api.registerTokenConnection(new MSCAPISignatureToken());
                break;
            }
            case PKCS_11: {
                OperationResult op2 = this.operationFactory.getOperation(UIOperation.class, "/fxml/pkcs11-params.fxml", new Object[]{this.api.getAppConfig().getApplicationName()}).perform();
                if (op2.getStatus().equals(BasicOperationStatus.USER_CANCEL)) {
                    return new OperationResult<Map<TokenOperationResultKey, Object>>(BasicOperationStatus.USER_CANCEL);
                }
                Pkcs11Params pkcs11Params = (Pkcs11Params)op2.getResult();
                String absolutePath = pkcs11Params.getPkcs11Lib().getAbsolutePath();
                map.put(TokenOperationResultKey.SELECTED_API_PARAMS, absolutePath);
                tokenId = this.api.registerTokenConnection(new Pkcs11SignatureTokenAdapter(new File(absolutePath), this.display.getPasswordInputCallback(), selectedCard.getTerminalIndex()));
                break;
            }
            default: {
                return new OperationResult<Map<TokenOperationResultKey, Object>>(CoreOperationStatus.UNSUPPORTED_PRODUCT);
            }
        }
        map.put(TokenOperationResultKey.TOKEN_ID, tokenId);
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setApiParam((String)map.get((Object)TokenOperationResultKey.SELECTED_API_PARAMS));
        connectionInfo.setSelectedApi((ScAPI)((Object)map.get((Object)TokenOperationResultKey.SELECTED_API)));
        connectionInfo.setEnv(this.api.getEnvironmentInfo());
        SCInfo info = new SCInfo();
        info.setAtr(selectedCard.getAtr());
        info.getInfos().add(connectionInfo);
        GenericCardAdapter cardAdapter = new GenericCardAdapter(info);
        map.put(TokenOperationResultKey.SELECTED_PRODUCT_ADAPTER, cardAdapter);
        return new OperationResult<Map<TokenOperationResultKey, Object>>(map);
    }
}

