/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageHelper {
    private static StageHelper instance;
    private static final Logger LOGGER;
    private String title;
    private ResourceBundle bundle;
    private static final String BUNDLE_NAME = "bundles/nexu";

    private StageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized StageHelper getInstance() {
        if (instance != null) return instance;
        Class<StageHelper> clazz = StageHelper.class;
        synchronized (StageHelper.class) {
            if (instance != null) return instance;
            instance = new StageHelper();
            instance.setBundle(ResourceBundle.getBundle(BUNDLE_NAME));
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String applicationName, String resourceBundleKey) {
        if (StringUtils.isBlank(applicationName) && StringUtils.isBlank(resourceBundleKey)) {
            this.title = "";
            return;
        }
        String translatedTitle = "";
        try {
            translatedTitle = this.getBundle().getString(resourceBundleKey);
        }
        catch (MissingResourceException mre) {
            LOGGER.warn("Resource bundle key \"{}\" is missing.", (Object)resourceBundleKey);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
        this.title = !StringUtils.isBlank(applicationName) && !StringUtils.isBlank(translatedTitle) ? applicationName + " - " + translatedTitle : (StringUtils.isBlank(applicationName) ? translatedTitle : (StringUtils.isBlank(translatedTitle) ? applicationName : ""));
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    static {
        LOGGER = LoggerFactory.getLogger(StageHelper.class);
    }
}

