/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.flow;

import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lu.nowina.nexu.api.Execution;
import lu.nowina.nexu.api.GetCertificateRequest;
import lu.nowina.nexu.api.GetCertificateResponse;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.Product;
import lu.nowina.nexu.api.ProductAdapter;
import lu.nowina.nexu.api.TokenId;
import lu.nowina.nexu.api.flow.BasicOperationStatus;
import lu.nowina.nexu.api.flow.Operation;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.flow.AbstractCoreFlow;
import lu.nowina.nexu.flow.operation.AdvancedCreationFeedbackOperation;
import lu.nowina.nexu.flow.operation.ConfigureProductOperation;
import lu.nowina.nexu.flow.operation.CoreOperationStatus;
import lu.nowina.nexu.flow.operation.CreateTokenOperation;
import lu.nowina.nexu.flow.operation.GetMatchingProductAdaptersOperation;
import lu.nowina.nexu.flow.operation.GetTokenConnectionOperation;
import lu.nowina.nexu.flow.operation.SaveProductOperation;
import lu.nowina.nexu.flow.operation.SelectPrivateKeyOperation;
import lu.nowina.nexu.flow.operation.TokenOperationResultKey;
import lu.nowina.nexu.view.core.UIDisplay;
import lu.nowina.nexu.view.core.UIOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetCertificateFlow
extends AbstractCoreFlow<GetCertificateRequest, GetCertificateResponse> {
    static final Logger logger = LoggerFactory.getLogger(GetCertificateFlow.class);

    public GetCertificateFlow(UIDisplay display, NexuAPI api) {
        super(display, api);
    }

    @Override
    protected Execution<GetCertificateResponse> process(NexuAPI api, GetCertificateRequest req) throws Exception {
        SignatureTokenConnection token = null;
        try {
            OperationResult getMatchingCardAdaptersOperationResult;
            block37: {
                OperationResult configureProductOperationResult;
                Execution<GetCertificateResponse> execution;
                block38: {
                    Object map;
                    OperationResult createTokenOperationResult;
                    block39: {
                        OperationResult getTokenConnectionOperationResult;
                        block40: {
                            OperationResult selectPrivateKeyOperationResult;
                            Product defaultProduct = api.getAppConfig().getDefaultProduct();
                            do {
                                Product selectedProduct;
                                if (defaultProduct != null) {
                                    selectedProduct = defaultProduct;
                                    defaultProduct = null;
                                } else {
                                    Object[] params = new Object[]{api.getAppConfig().getApplicationName(), api.detectCards(), api.detectProducts(), api};
                                    Operation operation = this.getOperationFactory().getOperation(UIOperation.class, "/fxml/product-selection.fxml", params);
                                    OperationResult selectProductOperationResult = operation.perform();
                                    if (selectProductOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) {
                                        selectedProduct = (Product)selectProductOperationResult.getResult();
                                    } else {
                                        execution = this.handleErrorOperationResult(selectProductOperationResult);
                                        return execution;
                                    }
                                }
                                getMatchingCardAdaptersOperationResult = this.getOperationFactory().getOperation(GetMatchingProductAdaptersOperation.class, Arrays.asList(selectedProduct), api).perform();
                                if (!getMatchingCardAdaptersOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) break block37;
                                List matchingProductAdapters = (List)getMatchingCardAdaptersOperationResult.getResult();
                                configureProductOperationResult = this.getOperationFactory().getOperation(ConfigureProductOperation.class, matchingProductAdapters, api).perform();
                                if (!configureProductOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) break block38;
                                matchingProductAdapters = (List)configureProductOperationResult.getResult();
                                createTokenOperationResult = this.getOperationFactory().getOperation(CreateTokenOperation.class, api, matchingProductAdapters).perform();
                                if (!createTokenOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) break block39;
                                map = (Map)createTokenOperationResult.getResult();
                                TokenId tokenId = (TokenId)map.get((Object)TokenOperationResultKey.TOKEN_ID);
                                getTokenConnectionOperationResult = this.getOperationFactory().getOperation(GetTokenConnectionOperation.class, api, tokenId).perform();
                                if (!getTokenConnectionOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) break block40;
                                token = (SignatureTokenConnection)getTokenConnectionOperationResult.getResult();
                                Product product = (Product)map.get((Object)TokenOperationResultKey.SELECTED_PRODUCT);
                                ProductAdapter productAdapter = (ProductAdapter)map.get((Object)TokenOperationResultKey.SELECTED_PRODUCT_ADAPTER);
                                selectPrivateKeyOperationResult = this.getOperationFactory().getOperation(SelectPrivateKeyOperation.class, token, api, product, productAdapter, req.getCertificateFilter()).perform();
                                if (!selectPrivateKeyOperationResult.getStatus().equals(BasicOperationStatus.SUCCESS)) continue;
                                DSSPrivateKeyEntry key = (DSSPrivateKeyEntry)selectPrivateKeyOperationResult.getResult();
                                if (((Boolean)map.get((Object)TokenOperationResultKey.ADVANCED_CREATION)).booleanValue()) {
                                    this.getOperationFactory().getOperation(AdvancedCreationFeedbackOperation.class, api, map).perform();
                                }
                                this.getOperationFactory().getOperation(SaveProductOperation.class, productAdapter, product, api).perform();
                                GetCertificateResponse resp = new GetCertificateResponse();
                                resp.setTokenId(tokenId);
                                CertificateToken certificate = key.getCertificate();
                                resp.setCertificate(certificate);
                                resp.setKeyId(certificate.getDSSIdAsString());
                                resp.setEncryptionAlgorithm(certificate.getEncryptionAlgorithm());
                                CertificateToken[] certificateChain = key.getCertificateChain();
                                if (certificateChain != null) {
                                    resp.setCertificateChain(certificateChain);
                                }
                                if (productAdapter.canReturnSuportedDigestAlgorithms(product)) {
                                    resp.setSupportedDigests(productAdapter.getSupportedDigestAlgorithms(product));
                                    resp.setPreferredDigest(productAdapter.getPreferredDigestAlgorithm(product));
                                }
                                if (api.getAppConfig().isEnablePopUps() && api.getAppConfig().isEnableInformativePopUps()) {
                                    this.getOperationFactory().getOperation(UIOperation.class, "/fxml/message.fxml", new Object[]{"certificates.flow.finished"}).perform();
                                }
                                Execution<GetCertificateResponse> execution2 = new Execution<GetCertificateResponse>(resp);
                                return execution2;
                            } while (selectPrivateKeyOperationResult.getStatus().equals(CoreOperationStatus.BACK));
                            Execution<GetCertificateResponse> execution3 = this.handleErrorOperationResult(selectPrivateKeyOperationResult);
                            return execution3;
                        }
                        Execution<GetCertificateResponse> execution4 = this.handleErrorOperationResult(getTokenConnectionOperationResult);
                        return execution4;
                    }
                    map = this.handleErrorOperationResult(createTokenOperationResult);
                    return map;
                }
                execution = this.handleErrorOperationResult(configureProductOperationResult);
                return execution;
            }
            Execution<GetCertificateResponse> execution = this.handleErrorOperationResult(getMatchingCardAdaptersOperationResult);
            return execution;
        }
        catch (Exception e) {
            logger.error("Flow error", e);
            throw this.handleException(e);
        }
        finally {
            if (token != null && req.isCloseToken()) {
                try {
                    token.close();
                }
                catch (Exception e) {
                    logger.error("Exception when closing token", e);
                }
            }
        }
    }
}

