/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FIFOCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 3868274387687593515L;
    private static final Logger logger = LoggerFactory.getLogger(FIFOCache.class);
    private final int maxSize;

    public FIFOCache(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        V eldestValue;
        boolean remove;
        boolean bl = remove = this.size() > this.maxSize;
        if (remove && eldest != null && (eldestValue = eldest.getValue()) != null && eldestValue instanceof AutoCloseable) {
            try {
                ((AutoCloseable)eldestValue).close();
            }
            catch (Exception e) {
                logger.error("Exception when removing eldest entry from cache: " + e.getMessage(), e);
            }
        }
        return remove;
    }
}

