/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import lu.nowina.nexu.ProxyConfigurer;
import lu.nowina.nexu.UserPreferences;
import lu.nowina.nexu.api.NexuAPI;
import lu.nowina.nexu.api.SystrayMenuItem;
import lu.nowina.nexu.api.flow.FutureOperationInvocation;
import lu.nowina.nexu.api.flow.OperationFactory;
import lu.nowina.nexu.api.flow.OperationResult;
import lu.nowina.nexu.systray.SystrayMenuInitializer;
import lu.nowina.nexu.view.core.NonBlockingUIOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystrayMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystrayMenu.class.getName());

    public SystrayMenu(OperationFactory operationFactory, NexuAPI api, UserPreferences prefs) {
        ResourceBundle resources = ResourceBundle.getBundle("bundles/nexu");
        List<SystrayMenuItem> extensionSystrayMenuItems = api.getExtensionSystrayMenuItems();
        SystrayMenuItem[] systrayMenuItems = new SystrayMenuItem[extensionSystrayMenuItems.size() + 2];
        systrayMenuItems[0] = this.createAboutSystrayMenuItem(operationFactory, api, resources);
        systrayMenuItems[1] = this.createPreferencesSystrayMenuItem(operationFactory, api, prefs, resources);
        int i = 2;
        for (SystrayMenuItem systrayMenuItem : extensionSystrayMenuItems) {
            systrayMenuItems[i++] = systrayMenuItem;
        }
        SystrayMenuItem exitMenuItem = this.createExitSystrayMenuItem(resources);
        String tooltip = api.getAppConfig().getApplicationName();
        URL trayIconURL = this.getClass().getResource("/tray-icon.png");
        try {
            switch (api.getEnvironmentInfo().getOs()) {
                case WINDOWS: 
                case MACOSX: {
                    Class.forName("lu.nowina.nexu.systray.AWTSystrayMenuInitializer").asSubclass(SystrayMenuInitializer.class).newInstance().init(tooltip, trayIconURL, operationFactory, exitMenuItem, systrayMenuItems);
                    break;
                }
                case LINUX: {
                    Class.forName("lu.nowina.nexu.systray.DorkboxSystrayMenuInitializer").asSubclass(SystrayMenuInitializer.class).newInstance().init(tooltip, trayIconURL, operationFactory, exitMenuItem, systrayMenuItems);
                    break;
                }
                case NOT_RECOGNIZED: {
                    LOGGER.warn("System tray is currently not supported for NOT_RECOGNIZED OS.");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled value: " + (Object)((Object)api.getEnvironmentInfo().getOs()));
                }
            }
        }
        catch (InstantiationException e) {
            LOGGER.error("Cannot initialize systray menu", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Cannot initialize systray menu", e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot initialize systray menu", e);
        }
    }

    private SystrayMenuItem createAboutSystrayMenuItem(OperationFactory operationFactory, final NexuAPI api, final ResourceBundle resources) {
        return new SystrayMenuItem(){

            @Override
            public String getLabel() {
                return resources.getString("systray.menu.about");
            }

            @Override
            public FutureOperationInvocation<Void> getFutureOperationInvocation() {
                return new FutureOperationInvocation<Void>(){

                    @Override
                    public OperationResult<Void> call(OperationFactory operationFactory) {
                        return operationFactory.getOperation(NonBlockingUIOperation.class, "/fxml/about.fxml", api.getAppConfig().getApplicationName(), api.getAppConfig().getApplicationVersion(), resources).perform();
                    }
                };
            }
        };
    }

    private SystrayMenuItem createPreferencesSystrayMenuItem(OperationFactory operationFactory, final NexuAPI api, final UserPreferences prefs, final ResourceBundle resources) {
        return new SystrayMenuItem(){

            @Override
            public String getLabel() {
                return resources.getString("systray.menu.preferences");
            }

            @Override
            public FutureOperationInvocation<Void> getFutureOperationInvocation() {
                return new FutureOperationInvocation<Void>(){

                    @Override
                    public OperationResult<Void> call(OperationFactory operationFactory) {
                        ProxyConfigurer proxyConfigurer = new ProxyConfigurer(api.getAppConfig(), prefs);
                        return operationFactory.getOperation(NonBlockingUIOperation.class, "/fxml/preferences.fxml", proxyConfigurer, prefs, !api.getAppConfig().isUserPreferencesEditable()).perform();
                    }
                };
            }
        };
    }

    private SystrayMenuItem createExitSystrayMenuItem(final ResourceBundle resources) {
        return new SystrayMenuItem(){

            @Override
            public String getLabel() {
                return resources.getString("systray.menu.exit");
            }

            @Override
            public FutureOperationInvocation<Void> getFutureOperationInvocation() {
                return new FutureOperationInvocation<Void>(){

                    @Override
                    public OperationResult<Void> call(OperationFactory operationFactory) {
                        LOGGER.info("Exiting...");
                        Platform.exit();
                        return new OperationResult<Void>((Void)null);
                    }
                };
            }
        };
    }
}

