/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import lu.nowina.nexu.UserPreferences;
import lu.nowina.nexu.api.AppConfig;
import lu.nowina.nexu.api.EnvironmentInfo;
import lu.nowina.nexu.api.OS;
import lu.nowina.nexu.web.WebUtilities;
import lu.nowina.nexu.windows.WindowsRegistry;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class ProxyConfigurer {
    private static final boolean isWindows = EnvironmentInfo.buildFromSystemProperties(System.getProperties()).getOs().equals((Object)OS.WINDOWS);
    private boolean useSystemProxy;
    private String proxyServer;
    private Integer proxyPort;
    private boolean proxyAuthentication;
    private String proxyUsername;
    private String proxyPassword;
    private boolean proxyUseHttps;

    public ProxyConfigurer(AppConfig config, UserPreferences preferences) {
        this.updateValues(config, preferences);
    }

    public void updateValues(AppConfig config, UserPreferences preferences) {
        this.useSystemProxy = preferences.isUseSystemProxy() != null ? preferences.isUseSystemProxy().booleanValue() : config.isUseSystemProxy();
        this.proxyServer = preferences.getProxyServer() != null ? preferences.getProxyServer() : config.getProxyServer();
        this.proxyPort = preferences.getProxyPort() != null ? preferences.getProxyPort() : config.getProxyPort();
        this.proxyUseHttps = preferences.isProxyUseHttps() != null ? preferences.isProxyUseHttps().booleanValue() : config.isProxyUseHttps();
        this.proxyAuthentication = preferences.isProxyAuthentication() != null ? preferences.isProxyAuthentication().booleanValue() : config.isProxyAuthentication();
        this.proxyUsername = preferences.getProxyUsername() != null ? preferences.getProxyUsername() : config.getProxyUsername();
        this.proxyPassword = preferences.getProxyPassword() != null ? preferences.getProxyPassword() : config.getProxyPassword();
    }

    public boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public boolean isProxyAuthentication() {
        return this.proxyAuthentication;
    }

    public boolean isProxyUseHttps() {
        return this.proxyUseHttps;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setupProxy(HttpRequestBase request) {
        if (isWindows && this.useSystemProxy) {
            String proxyAddress;
            HttpHost proxy = null;
            if (WindowsRegistry.isProxyEnable() && (proxyAddress = WindowsRegistry.getProxyServer()) != null) {
                String hostName;
                String hostAddress;
                if (WebUtilities.isIpAddress(request.getURI().getAuthority())) {
                    hostAddress = request.getURI().getAuthority();
                    hostName = WebUtilities.resolveHostName(hostAddress);
                } else {
                    hostName = request.getURI().getAuthority();
                    hostAddress = WebUtilities.resolveIp(hostName);
                }
                boolean bypassProxy = false;
                for (String bypassAddress : WindowsRegistry.getBypassAddresses()) {
                    String bypassPrefix;
                    int indexOfStar = bypassAddress.indexOf(42);
                    String string = bypassPrefix = indexOfStar == -1 ? bypassAddress : bypassAddress.substring(0, indexOfStar);
                    if (bypassPrefix.length() == 0 || (hostName == null || !hostName.startsWith(bypassPrefix)) && (hostAddress == null || !hostAddress.startsWith(bypassPrefix))) continue;
                    bypassProxy = true;
                    break;
                }
                if (!bypassProxy) {
                    String[] array = proxyAddress.split(":");
                    String proxyHost = array[0];
                    String proxyPort = array[1];
                    proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort), this.proxyUseHttps ? "https" : "http");
                }
            }
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            request.setConfig(config);
        } else if (!StringUtils.isEmpty(this.proxyServer)) {
            HttpHost proxy = new HttpHost(this.proxyServer, (int)this.proxyPort, this.proxyUseHttps ? "https" : "http");
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            request.setConfig(config);
        } else {
            RequestConfig config = RequestConfig.custom().build();
            request.setConfig(config);
        }
    }

    public CredentialsProvider getProxyCredentialsProvider(HttpHost proxy) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (proxy != null && this.proxyAuthentication) {
            credsProvider.setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
        }
        return credsProvider;
    }
}

