/*
 * Decompiled with CFR 0.152.
 */
package lu.nowina.nexu;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import lu.nowina.nexu.DatabaseEventHandler;
import lu.nowina.nexu.ProductDatabase;
import lu.nowina.nexu.TechnicalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductDatabaseLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductDatabaseLoader.class.getName());

    public static <T extends ProductDatabase> T load(Class<T> databaseClass, final File f) {
        ProductDatabase db;
        if (!f.exists()) {
            try {
                db = (ProductDatabase)databaseClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new TechnicalException("Cannot create database", e);
            }
            catch (IllegalAccessException e) {
                throw new TechnicalException("Cannot create database", e);
            }
        }
        try {
            db = ProductDatabaseLoader.load(databaseClass, f.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new TechnicalException("Cannot load database", e);
        }
        db.setOnAddRemoveAction(new DatabaseEventHandler(){

            public <P extends ProductDatabase> void execute(P db) {
                ProductDatabaseLoader.saveAs(db, f);
            }
        });
        return (T)db;
    }

    public static <T extends ProductDatabase> T load(Class<T> databaseClass, URL url) {
        try {
            JAXBContext ctx = ProductDatabaseLoader.createJaxbContext(databaseClass);
            Unmarshaller u = ctx.createUnmarshaller();
            return (T)((ProductDatabase)u.unmarshal(url));
        }
        catch (Exception e) {
            throw new TechnicalException("Cannot load database", e);
        }
    }

    private static <T extends ProductDatabase> JAXBContext createJaxbContext(Class<T> databaseClass) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{databaseClass});
        }
        catch (JAXBException e) {
            LOGGER.error("Cannot instanciate JAXBContext", e);
            throw new TechnicalException("Cannot instanciate JAXBContext", e);
        }
    }

    static <T extends ProductDatabase> void saveAs(T db, File file) {
        try {
            JAXBContext ctx = ProductDatabaseLoader.createJaxbContext(db.getClass());
            Marshaller m = ctx.createMarshaller();
            try (FileOutputStream out = new FileOutputStream(file);){
                m.marshal(db, (OutputStream)out);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot save database", e);
            throw new TechnicalException("Cannot save database", e);
        }
    }
}

