/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.utils;

public class CryptoUtils {
    public static void zeroBlock(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            nArray[n3] = 0;
            ++n3;
        }
    }

    public static void zeroBlock(int[] nArray) {
        CryptoUtils.zeroBlock(nArray, 0, nArray.length);
    }

    public static void zeroBlock(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = 0;
            ++n3;
        }
    }

    public static void zeroBlock(byte[] byArray) {
        CryptoUtils.zeroBlock(byArray, 0, byArray.length);
    }

    public static void squashBytesToShortsLE(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 1) + 1;
            nArray[n2 + n4] = (byArray[n5--] & 0xFF) << 8 | byArray[n5] & 0xFF;
            ++n4;
        }
    }

    public static void squashBytesToShortsBE(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 1);
            nArray[n2 + n4] = (byArray[n5++] & 0xFF) << 8 | byArray[n5] & 0xFF;
            ++n4;
        }
    }

    public static void squashBytesToIntsLE(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 2);
            nArray[n2 + n4] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | byArray[n5] << 24;
            ++n4;
        }
    }

    public static void squashBytesToInts(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 2);
            nArray[n2 + n4] = (byArray[n5++] & 0xFF) << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5] & 0xFF;
            ++n4;
        }
    }

    public static void spreadShortsToBytesLE(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray[n2 + (n4 << 1) + 1] = (byte)(nArray[n + n4] >>> 8);
            byArray[n2 + (n4 << 1)] = (byte)nArray[n + n4];
            ++n4;
        }
    }

    public static void spreadShortsToBytesBE(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray[n2 + (n4 << 1)] = (byte)(nArray[n + n4] >>> 8);
            byArray[n2 + (n4 << 1) + 1] = (byte)nArray[n + n4];
            ++n4;
        }
    }

    public static void spreadIntsToBytesLE(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 + (n4 << 2);
            int n6 = n + n4;
            byArray[n5++] = (byte)nArray[n6];
            byArray[n5++] = (byte)(nArray[n6] >>> 8);
            byArray[n5++] = (byte)(nArray[n6] >>> 16);
            byArray[n5] = (byte)(nArray[n6] >>> 24);
            ++n4;
        }
    }

    public static void spreadIntsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 + (n4 << 2);
            int n6 = n + n4;
            byArray[n5++] = (byte)(nArray[n6] >>> 24);
            byArray[n5++] = (byte)(nArray[n6] >>> 16);
            byArray[n5++] = (byte)(nArray[n6] >>> 8);
            byArray[n5] = (byte)nArray[n6];
            ++n4;
        }
    }

    public static boolean equalsBlock(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        return CryptoUtils.equalsBlock(byArray, 0, byArray2, 0, byArray.length);
    }

    public static boolean equalsBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static void copyBlock(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n];
            ++n;
        }
    }

    public static void copyBlock(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n2 + n4] = nArray[n + n4];
            ++n4;
        }
    }

    public static void copyBlock(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            byArray2[n] = byArray[n];
            ++n;
        }
    }

    public static void copyBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n2 + n4] = byArray[n + n4];
            ++n4;
        }
    }

    private CryptoUtils() {
    }
}

