/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security.rsa;

import iaik.me.security.Cipher;
import iaik.me.security.CryptoException;
import iaik.me.security.MessageDigest;
import iaik.me.security.PrivateKey;
import iaik.me.security.PublicKey;
import iaik.me.security.SecureRandom;
import iaik.me.security.Signature;
import iaik.me.security.rsa.MGF;
import iaik.me.utils.CryptoUtils;

public class RSAPssSignature
extends Signature {
    final byte[] d = new byte[8];
    final int c = 20;
    private int b;
    private Cipher a;

    public boolean verify(byte[] byArray) throws CryptoException {
        byte[] byArray2 = this.md.digest();
        MessageDigest messageDigest = this.b();
        byte[] byArray3 = this.a.doFinal(byArray);
        return this.a(byArray3, byArray2, 20, messageDigest);
    }

    public byte[] sign() throws CryptoException {
        return this.a.doFinal(this.a(this.md.digest(), 20, this.md));
    }

    private boolean a(byte[] byArray, byte[] byArray2, int n, MessageDigest messageDigest) throws CryptoException {
        int n2 = this.b - 1;
        int n3 = (n2 + 7) / 8;
        int n4 = messageDigest.getDigestLength();
        int n5 = n3 - n4 - 1;
        int n6 = n5 - n - 1;
        int cfr_ignored_0 = 8 * n3 - n2;
        byte by = 0;
        if ((byArray[0] & by) != 0) {
            throw new CryptoException("Invalid signature. Leftmost 8emLen - emBits not all zero.");
        }
        MGF.mgf1(byArray, 0, n5, byArray, n5, n4, messageDigest);
        byArray[0] = (byte)(byArray[0] & 255 >> 8 * n3 - n2);
        int n7 = 0;
        while (n7 < n6) {
            if (byArray[n7] != 0) {
                throw new CryptoException("Bad PSS padding: wrong leading zeroes!");
            }
            ++n7;
        }
        if (byArray[n7] != 1 || byArray[byArray.length - 1] != -68) {
            throw new CryptoException("Bad PSS padding: no 0x01 or 0xbc!");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, n5 - n, byArray3, 0, n);
        messageDigest.reset();
        messageDigest.update(this.d);
        messageDigest.update(byArray2);
        byte[] byArray4 = messageDigest.digest(byArray3);
        return CryptoUtils.equalsBlock(byArray4, 0, byArray, n5, n4 - 1);
    }

    private byte[] a(byte[] byArray, int n, MessageDigest messageDigest) throws CryptoException {
        int n2 = this.b - 1;
        int n3 = (n2 + 7) / 8;
        byte[] byArray2 = new byte[n3];
        byArray2[byArray2.length - 1] = -68;
        int n4 = n3 - messageDigest.getDigestLength() - 1;
        byte[] byArray3 = new byte[n];
        SecureRandom secureRandom = SecureRandom.getDefault();
        secureRandom.nextBytes(byArray3);
        messageDigest.update(byArray2, 0, 8);
        messageDigest.update(byArray);
        messageDigest.update(byArray3);
        messageDigest.digest(byArray2, n4);
        int n5 = n4 - 1 - n;
        CryptoUtils.zeroBlock(byArray2, 0, n5);
        byArray2[n5] = 1;
        System.arraycopy(byArray3, 0, byArray2, n5 + 1, n);
        MGF.mgf1(byArray2, 0, n4, byArray2, n4, messageDigest.getDigestLength(), messageDigest);
        byte by = (byte)(255 >> 8 * n3 - n2);
        byArray2[0] = (byte)(byArray2[0] & by);
        return byArray2;
    }

    public void initVerify(PublicKey publicKey) throws CryptoException {
        this.a = Cipher.getInstance("RSA/ECB/NoPadding");
        this.a.init(2, publicKey);
        this.md = this.b();
        this.b = publicKey.getKeyLength();
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws CryptoException {
        this.a = Cipher.getInstance("RSA/ECB/NoPadding");
        this.a.init(1, privateKey);
        this.md = this.b();
        this.b = privateKey.getKeyLength();
    }

    private MessageDigest b() throws CryptoException {
        if (this.md != null) {
            return this.md;
        }
        String string = this.getAlgorithm();
        if (!string.endsWith("withRSAandMGF1")) {
            throw new CryptoException("Invalid RSA signature algorithm: " + string);
        }
        string = string.substring(0, string.indexOf("with"));
        return MessageDigest.getInstance(string);
    }
}

