/*
 * Decompiled with CFR 0.152.
 */
package iaik.me.security;

import iaik.me.asn1.ASN1;
import iaik.me.security.BigInteger;
import iaik.me.security.CryptoBag;
import iaik.me.security.rsa.OAEPParams;
import java.io.IOException;

public class PublicKey
extends CryptoBag {
    private String a;

    public static PublicKey makeRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        PublicKey publicKey = new PublicKey(3);
        publicKey.a(2, bigInteger);
        publicKey.a(3, bigInteger2);
        return publicKey;
    }

    public static PublicKey makeRSAOAEPPublicKey(BigInteger bigInteger, BigInteger bigInteger2, Object object) {
        PublicKey publicKey = new PublicKey(12);
        publicKey.a(2, bigInteger);
        publicKey.a(3, bigInteger2);
        publicKey.a(23, object);
        return publicKey;
    }

    public static PublicKey makeDSAPublicKey(BigInteger bigInteger, CryptoBag cryptoBag) {
        if (cryptoBag.getType() != 7) {
            throw new RuntimeException("Parameters must be DSA parameters!");
        }
        PublicKey publicKey = new PublicKey(5);
        publicKey.a(11, bigInteger);
        publicKey.a(12, cryptoBag);
        return publicKey;
    }

    public static PublicKey makeDHPublicKey(BigInteger bigInteger, CryptoBag cryptoBag) {
        if (cryptoBag.getType() != 10) {
            throw new RuntimeException("Parameters must be DH parameters!");
        }
        PublicKey publicKey = new PublicKey(8);
        publicKey.a(17, bigInteger);
        publicKey.a(18, cryptoBag);
        return publicKey;
    }

    public ASN1 getASN1() {
        ASN1 aSN1 = ASN1.makeSequence(2);
        ASN1 aSN12 = null;
        switch (this.getType()) {
            case 3: {
                aSN1.addElement(ASN1.makeAlgorithmId(ASN1.getObjectId("RSA"), null));
                aSN12 = ASN1.makeSequence(2);
                aSN12.addElement(new ASN1(2, this.getBigInteger(2)));
                aSN12.addElement(new ASN1(2, this.getBigInteger(3)));
                break;
            }
            case 12: {
                OAEPParams oAEPParams = this.getOAEP(23);
                aSN1.addElement(ASN1.makeAlgorithmId(ASN1.getObjectId("RSAES-OAEP"), oAEPParams.getASN1()));
                aSN12 = ASN1.makeSequence(2);
                aSN12.addElement(new ASN1(2, this.getBigInteger(2)));
                aSN12.addElement(new ASN1(2, this.getBigInteger(3)));
                break;
            }
            case 5: {
                aSN1.addElement(this.getCryptoBag(12).getASN1());
                aSN12 = new ASN1(2, this.getBigInteger(11));
                break;
            }
            case 8: {
                aSN1.addElement(this.getCryptoBag(18).getASN1());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        aSN1.addElement(new ASN1(3, aSN12.getEncoded()));
        return aSN1;
    }

    private void a(ASN1 aSN1) throws IOException {
        if (aSN1.getType() != 16) {
            throw new IOException("Not a PublicKeyInfo!");
        }
        this.a = aSN1.getElementAt(0).gvAlgorithm();
        byte[] byArray = aSN1.getElementAt(1).gvByteArray();
        ASN1 aSN12 = new ASN1(byArray);
        String string = ASN1.getName(this.a);
        if (string.equals("RSA")) {
            this.c(3);
            this.a(2, aSN12.getElementAt(0).gvBigInteger());
            this.a(3, aSN12.getElementAt(1).gvBigInteger());
        } else if (string.equals("DSA")) {
            this.c(5);
            this.a(11, aSN12.gvBigInteger());
            CryptoBag cryptoBag = new CryptoBag(aSN1.getElementAt(0));
            if (cryptoBag.getType() != 7) {
                throw new IOException("Invalid ASN.1 algorithm parameters, not DSA");
            }
            this.a(12, cryptoBag);
        } else if (string.equals("DH")) {
            this.c(8);
            this.a(17, aSN12.gvBigInteger());
            CryptoBag cryptoBag = new CryptoBag(aSN1.getElementAt(0));
            if (cryptoBag.getType() != 10) {
                throw new IOException("Invalid ASN.1 algorithm parameters, not DH");
            }
            this.a(18, cryptoBag);
        } else if (string.equals("RSAES-OAEP")) {
            this.c(12);
            ASN1 aSN13 = aSN1.getElementAt(0).getElementAt(1);
            OAEPParams oAEPParams = aSN13 != null ? new OAEPParams(aSN13) : null;
            this.a(23, oAEPParams);
            this.a(2, aSN12.getElementAt(0).gvBigInteger());
            this.a(3, aSN12.getElementAt(1).gvBigInteger());
        } else {
            throw new IOException("Unknown public key algorithm " + this.a);
        }
    }

    public PublicKey(ASN1 aSN1) throws IOException {
        this.a(aSN1);
    }

    private PublicKey(int n) {
        super(n);
    }
}

