/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.tsl.KeyUsageBit;
import eu.europa.esig.dss.x509.CertificateToken;

public class KeyUsageCondition
extends Condition {
    private static final long serialVersionUID = -5078159553328523044L;
    private final KeyUsageBit bit;
    private final boolean value;

    public KeyUsageCondition(KeyUsageBit bit, boolean value) {
        this.bit = bit;
        this.value = value;
    }

    public KeyUsageCondition(String usage, boolean value) {
        this(KeyUsageBit.valueOf(usage), value);
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        boolean keyUsage = certificateToken.checkKeyUsage(this.bit);
        return keyUsage == this.value;
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("KeyUsageCondition: ").append(this.bit.name()).append('=').append(this.value).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

