/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSXmlErrorListener;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.NamespaceContextMap;
import eu.europa.esig.dss.XAdESNamespaces;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DomUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DomUtils.class);
    private static DocumentBuilderFactory dbFactory;
    private static final XPathFactory factory;
    private static NamespaceContextMap namespacePrefixMapper;
    private static final Map<String, String> namespaces;

    private DomUtils() {
    }

    private static void registerDefaultNamespaces() {
        DomUtils.registerNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        DomUtils.registerNamespace("dsig", "http://www.w3.org/2000/09/xmldsig#");
        DomUtils.registerNamespace("xades", XAdESNamespaces.XAdES);
        DomUtils.registerNamespace("xades141", "http://uri.etsi.org/01903/v1.4.1#");
        DomUtils.registerNamespace("xades122", "http://uri.etsi.org/01903/v1.2.2#");
        DomUtils.registerNamespace("xades111", "http://uri.etsi.org/01903/v1.1.1#");
    }

    public static boolean registerNamespace(String prefix, String namespace) {
        String put = namespaces.put(prefix, namespace);
        namespacePrefixMapper.registerNamespace(prefix, namespace);
        return put == null;
    }

    private static void ensureDocumentBuilder() throws DSSException {
        if (dbFactory != null) {
            return;
        }
        dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        try {
            dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbFactory.setXIncludeAware(false);
            dbFactory.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            throw new DSSException(e);
        }
    }

    public static TransformerFactory getSecureTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            throw new DSSException(e);
        }
        transformerFactory.setErrorListener(new DSSXmlErrorListener());
        return transformerFactory;
    }

    public static Transformer getSecureTransformer() {
        TransformerFactory transformerFactory = DomUtils.getSecureTransformerFactory();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
        }
        catch (TransformerConfigurationException e) {
            throw new DSSException(e);
        }
        transformer.setErrorListener(new DSSXmlErrorListener());
        return transformer;
    }

    public static Document buildDOM() {
        DomUtils.ensureDocumentBuilder();
        try {
            return dbFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new DSSException(e);
        }
    }

    public static Document buildDOM(String xmlString) throws DSSException {
        return DomUtils.buildDOM(xmlString.getBytes(StandardCharsets.UTF_8));
    }

    public static Document buildDOM(byte[] bytes) throws DSSException {
        return DomUtils.buildDOM(new ByteArrayInputStream(bytes));
    }

    public static Document buildDOM(DSSDocument dssDocument) throws DSSException {
        return DomUtils.buildDOM(dssDocument.openStream());
    }

    public static boolean isDOM(byte[] bytes) {
        try {
            Document dom = DomUtils.buildDOM(bytes);
            return dom != null;
        }
        catch (DSSException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document buildDOM(InputStream inputStream) throws DSSException {
        try (InputStream is = inputStream;){
            Document rootElement;
            DomUtils.ensureDocumentBuilder();
            Document document = rootElement = dbFactory.newDocumentBuilder().parse(is);
            return document;
        }
        catch (Exception e) {
            throw new DSSException("Unable to parse content (XML expected)", e);
        }
    }

    public static Document createDocument(String namespaceURI, String qualifiedName) {
        DOMImplementation domImpl;
        DomUtils.ensureDocumentBuilder();
        try {
            domImpl = dbFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException e) {
            throw new DSSException(e);
        }
        return domImpl.createDocument(namespaceURI, qualifiedName, null);
    }

    public static Element addElement(Document document, Element parentDom, String namespace, String name) {
        Element dom = document.createElementNS(namespace, name);
        parentDom.appendChild(dom);
        return dom;
    }

    private static XPathExpression createXPathExpression(String xpathString) throws DSSException {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(namespacePrefixMapper);
        try {
            XPathExpression expr = xpath.compile(xpathString);
            return expr;
        }
        catch (XPathExpressionException ex) {
            throw new DSSException(ex);
        }
    }

    public static String getValue(Node xmlNode, String xPathString) throws DSSException {
        try {
            XPathExpression xPathExpression = DomUtils.createXPathExpression(xPathString);
            String string = (String)xPathExpression.evaluate(xmlNode, XPathConstants.STRING);
            return string.trim();
        }
        catch (XPathExpressionException e) {
            throw new DSSException(e);
        }
    }

    public static NodeList getNodeList(Node xmlNode, String xPathString) throws DSSException {
        try {
            XPathExpression expr = DomUtils.createXPathExpression(xPathString);
            NodeList evaluated = (NodeList)expr.evaluate(xmlNode, XPathConstants.NODESET);
            return evaluated;
        }
        catch (XPathExpressionException e) {
            throw new DSSException(e);
        }
    }

    public static Node getNode(Node xmlNode, String xPathString) {
        NodeList list = DomUtils.getNodeList(xmlNode, xPathString);
        if (list.getLength() > 1) {
            throw new DSSException("More than one result for XPath: " + xPathString);
        }
        return list.item(0);
    }

    public static Element getElement(Node xmlNode, String xPathString) {
        return (Element)DomUtils.getNode(xmlNode, xPathString);
    }

    public static boolean isNotEmpty(Node xmlNode, String xPathString) {
        NodeList nodeList = DomUtils.getNodeList(xmlNode, xPathString + "/child::node()[not(self::text())]");
        return nodeList != null && nodeList.getLength() > 0;
    }

    public static Element addTextElement(Document document, Element parentDom, String namespace, String name, String value) {
        Element dom = document.createElementNS(namespace, name);
        parentDom.appendChild(dom);
        Text valueNode = document.createTextNode(value);
        dom.appendChild(valueNode);
        return dom;
    }

    public static void setTextNode(Document document, Element parentDom, String text) {
        Text textNode = document.createTextNode(text);
        parentDom.appendChild(textNode);
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        try {
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            xmlGregorianCalendar.setFractionalSecond(null);
            xmlGregorianCalendar = xmlGregorianCalendar.normalize();
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("Unable to properly convert a Date to an XMLGregorianCalendar " + e.getMessage(), e);
            return null;
        }
    }

    public static Date getDate(String text) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(text);
            return xmlGregorianCalendar.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn("Unable to parse '{}'", (Object)text);
            return null;
        }
    }

    public static List<String> getChildrenNames(Node xmlNode, String xPathString) {
        ArrayList<String> childrenNames = new ArrayList<String>();
        Element element = DomUtils.getElement(xmlNode, xPathString);
        if (element != null) {
            NodeList unsignedProperties = element.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                Node node = unsignedProperties.item(ii);
                childrenNames.add(node.getLocalName());
            }
        }
        return childrenNames;
    }

    public static void writeDocumentTo(Document dom, OutputStream os) throws DSSException {
        try {
            DOMSource xmlSource = new DOMSource(dom);
            StreamResult outputTarget = new StreamResult(os);
            Transformer transformer = DomUtils.getSecureTransformer();
            transformer.transform(xmlSource, outputTarget);
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    public static DSSDocument createDssDocumentFromDomDocument(Document document, String name) {
        InMemoryDocument dssDoc = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            DomUtils.writeDocumentTo(document, baos);
            dssDoc = new InMemoryDocument(baos.toByteArray(), name, MimeType.XML);
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
        return dssDoc;
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            Transformer transformer = DomUtils.getSecureTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    static {
        factory = XPathFactory.newInstance();
        namespacePrefixMapper = new NamespaceContextMap();
        namespaces = new HashMap<String, String>();
        DomUtils.registerDefaultNamespaces();
    }
}

