/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;

public class ProcessProxy
extends Thread {
    private final InputStream is;
    private final OutputStream os;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    public ProcessProxy(String processName, InputStream inputStreamFromConsole, OutputStream outputStreamToProcess) {
        this.is = inputStreamFromConsole;
        this.os = outputStreamToProcess;
        this.setName(processName);
        this.setDaemon(true);
    }

    public void close() {
        this.interrupt();
        try {
            if (this.os != null) {
                this.os.flush();
            }
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void start() {
        super.start();
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream os = this.os;
        InputStream is = this.is;
        this.countDownLatch.countDown();
        try {
            if (os == null) {
                while (is.read() != -1) {
                }
            } else {
                int readInt;
                while ((readInt = is.read()) != -1) {
                    os.write(readInt);
                    if (readInt != 10) continue;
                    os.flush();
                    OutputStream outputStream = os;
                    synchronized (outputStream) {
                        os.notify();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

