/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.jna.linux.AppIndicator;
import dorkbox.systemTray.jna.linux.AppIndicatorInstanceStruct;
import dorkbox.systemTray.jna.linux.GEventCallback;
import dorkbox.systemTray.jna.linux.GdkEventButton;
import dorkbox.systemTray.jna.linux.Gobject;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.swingUI.SwingMenu;
import dorkbox.systemTray.swingUI.SwingUI;
import dorkbox.systemTray.swingUI.TrayPopup;
import dorkbox.systemTray.util.ImageUtils;
import dorkbox.util.SwingUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class _AppIndicatorTray
extends Tray
implements SwingUI {
    private volatile AppIndicatorInstanceStruct appIndicator;
    private boolean isActive = false;
    private volatile Runnable popupRunnable;
    private AtomicBoolean shuttingDown = new AtomicBoolean();
    private GEventCallback gtkCallback;
    private Pointer dummyMenu;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile boolean setName = false;

    public _AppIndicatorTray(final SystemTray systemTray) {
        Gtk.startGui();
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                File image = ImageUtils.getTransparentImage(ImageUtils.ENTRY_SIZE);
                String id = System.nanoTime() + "DBST";
                _AppIndicatorTray.this.appIndicator = AppIndicator.app_indicator_new(id, image.getAbsolutePath(), 0);
                _AppIndicatorTray.this.createAppIndicatorMenu();
            }
        });
        Gtk.waitForStartup();
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                final SwingMenu swingMenu = new SwingMenu(null){

                    @Override
                    public void setEnabled(final MenuItem menuItem) {
                        Gtk.dispatch(new Runnable(){

                            @Override
                            public void run() {
                                boolean enabled = menuItem.getEnabled();
                                if (_AppIndicatorTray.this.visible && !enabled) {
                                    AppIndicator.app_indicator_set_status(_AppIndicatorTray.this.appIndicator, 0);
                                    _AppIndicatorTray.this.visible = false;
                                } else if (!_AppIndicatorTray.this.visible && enabled) {
                                    AppIndicator.app_indicator_set_status(_AppIndicatorTray.this.appIndicator, 1);
                                    _AppIndicatorTray.this.visible = true;
                                }
                            }
                        });
                    }

                    @Override
                    public void setImage(MenuItem menuItem) {
                        _AppIndicatorTray.this.imageFile = menuItem.getImage();
                        if (_AppIndicatorTray.this.imageFile == null) {
                            return;
                        }
                        Gtk.dispatch(new Runnable(){

                            @Override
                            public void run() {
                                AppIndicator.app_indicator_set_icon(_AppIndicatorTray.this.appIndicator, _AppIndicatorTray.this.imageFile.getAbsolutePath());
                                if (!_AppIndicatorTray.this.isActive) {
                                    _AppIndicatorTray.this.isActive = true;
                                    AppIndicator.app_indicator_set_status(_AppIndicatorTray.this.appIndicator, 1);
                                    _AppIndicatorTray.this.hookMenuOpen();
                                }
                            }
                        });
                        SwingUtil.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((TrayPopup)_native).setTitleBarImage(_AppIndicatorTray.this.imageFile);
                            }
                        });
                    }

                    @Override
                    public void setText(MenuItem menuItem) {
                    }

                    @Override
                    public void setShortcut(MenuItem menuItem) {
                    }

                    @Override
                    public void remove() {
                        if (!_AppIndicatorTray.this.shuttingDown.getAndSet(true)) {
                            final AppIndicatorInstanceStruct savedAppIndicator = _AppIndicatorTray.this.appIndicator;
                            _AppIndicatorTray.this.appIndicator = null;
                            Gtk.dispatch(new Runnable(){

                                @Override
                                public void run() {
                                    AppIndicator.app_indicator_set_status(savedAppIndicator, 0);
                                    Pointer p = savedAppIndicator.getPointer();
                                    Gobject.g_object_unref(p);
                                }
                            });
                            Gtk.shutdownGui();
                            super.remove();
                        }
                    }
                };
                TrayPopup popupMenu = (TrayPopup)swingMenu._native;
                popupMenu.pack();
                popupMenu.setFocusable(true);
                popupMenu.setOnHideRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (_AppIndicatorTray.this.appIndicator == null) {
                            return;
                        }
                        Gtk.dispatchAndWait(new Runnable(){

                            @Override
                            public void run() {
                                _AppIndicatorTray.this.createAppIndicatorMenu();
                                _AppIndicatorTray.this.hookMenuOpen();
                            }
                        });
                    }
                });
                _AppIndicatorTray.this.popupRunnable = new Runnable(){

                    @Override
                    public void run() {
                        Point point = MouseInfo.getPointerInfo().getLocation();
                        TrayPopup popupMenu = (TrayPopup)swingMenu._native;
                        popupMenu.doShow(point, SystemTray.DEFAULT_TRAY_SIZE);
                    }
                };
                _AppIndicatorTray.this.bind(swingMenu, null, systemTray);
            }
        });
    }

    private void hookMenuOpen() {
        PointerByReference menuServer = new PointerByReference();
        PointerByReference rootMenuItem = new PointerByReference();
        Gobject.g_object_get(this.appIndicator.getPointer(), "dbus-menu-server", menuServer, null);
        Gobject.g_object_get(menuServer.getValue(), "root-node", rootMenuItem, null);
        this.gtkCallback = new GEventCallback(){

            @Override
            public void callback(Pointer notUsed, GdkEventButton event) {
                Gtk.gtk_menu_shell_deactivate(_AppIndicatorTray.this.dummyMenu);
                SwingUtil.invokeLater(_AppIndicatorTray.this.popupRunnable);
            }
        };
        Gobject.g_signal_connect_object(rootMenuItem.getValue(), "about-to-show", this.gtkCallback, null, 0);
    }

    private void createAppIndicatorMenu() {
        this.dummyMenu = Gtk.gtk_menu_new();
        Pointer item = Gtk.gtk_image_menu_item_new_with_mnemonic("");
        Gtk.gtk_menu_shell_append(this.dummyMenu, item);
        Gtk.gtk_widget_show_all(item);
        AppIndicator.app_indicator_set_menu(this.appIndicator, this.dummyMenu);
        if (!this.setName) {
            this.setName = true;
            AppIndicator.app_indicator_set_title(this.appIndicator, "SystemTray");
        }
    }

    @Override
    public final boolean hasImage() {
        return this.imageFile != null;
    }
}

