/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.swingUI.AdjustedJMenu;
import dorkbox.systemTray.swingUI.SwingMenuItem;
import dorkbox.systemTray.swingUI.SwingMenuItemCheckbox;
import dorkbox.systemTray.swingUI.SwingMenuItemSeparator;
import dorkbox.systemTray.swingUI.SwingMenuItemStatus;
import dorkbox.systemTray.swingUI.TrayPopup;
import dorkbox.util.SwingUtil;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

class SwingMenu
implements MenuPeer {
    final JComponent _native;
    private final SwingMenu parent;

    SwingMenu(SwingMenu parent) {
        this.parent = parent;
        if (parent == null) {
            this._native = new TrayPopup();
        } else {
            this._native = new AdjustedJMenu();
            parent._native.add(this._native);
        }
    }

    @Override
    public void add(final Menu parentMenu, final Entry entry, int index) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (entry instanceof Menu) {
                    SwingMenu swingMenu = new SwingMenu(SwingMenu.this);
                    ((Menu)entry).bind(swingMenu, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Separator) {
                    SwingMenuItemSeparator item = new SwingMenuItemSeparator(SwingMenu.this);
                    entry.bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Checkbox) {
                    SwingMenuItemCheckbox item = new SwingMenuItemCheckbox(SwingMenu.this);
                    ((Checkbox)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Status) {
                    SwingMenuItemStatus item = new SwingMenuItemStatus(SwingMenu.this);
                    ((Status)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof MenuItem) {
                    SwingMenuItem item = new SwingMenuItem(SwingMenu.this);
                    ((MenuItem)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                }
            }
        });
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                File imageFile = menuItem.getImage();
                if (imageFile != null) {
                    ImageIcon origIcon = new ImageIcon(imageFile.getAbsolutePath());
                    ((AdjustedJMenu)SwingMenu.this._native).setIcon(origIcon);
                } else {
                    ((AdjustedJMenu)SwingMenu.this._native).setIcon(null);
                }
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenu.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((AdjustedJMenu)SwingMenu.this._native).setText(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        final int vKey = SwingUtil.getVirtualKey(shortcut);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((AdjustedJMenu)SwingMenu.this._native).setMnemonic(vKey);
            }
        });
    }

    @Override
    public synchronized void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenu.this._native.setVisible(false);
                SwingMenu.this._native.removeAll();
                if (SwingMenu.this.parent != null) {
                    ((SwingMenu)SwingMenu.this).parent._native.remove(SwingMenu.this._native);
                } else {
                    ((TrayPopup)SwingMenu.this._native).close();
                }
            }
        });
    }
}

