/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.nativeUI.AwtMenuItem;
import dorkbox.systemTray.nativeUI.AwtMenuItemCheckbox;
import dorkbox.systemTray.nativeUI.AwtMenuItemSeparator;
import dorkbox.systemTray.nativeUI.AwtMenuItemStatus;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.util.SwingUtil;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;

class AwtMenu
implements MenuPeer {
    volatile java.awt.Menu _native;
    private final AwtMenu parent;

    AwtMenu(AwtMenu parent) {
        this.parent = parent;
        if (parent == null) {
            this._native = new PopupMenu();
        } else {
            this._native = new java.awt.Menu();
            parent._native.add(this._native);
        }
    }

    @Override
    public void add(final Menu parentMenu, final Entry entry, int index) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (entry instanceof Menu) {
                    AwtMenu swingMenu = new AwtMenu(AwtMenu.this);
                    ((Menu)entry).bind(swingMenu, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Separator) {
                    AwtMenuItemSeparator item = new AwtMenuItemSeparator(AwtMenu.this);
                    entry.bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Checkbox) {
                    AwtMenuItemCheckbox item = new AwtMenuItemCheckbox(AwtMenu.this);
                    ((Checkbox)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Status) {
                    AwtMenuItemStatus item = new AwtMenuItemStatus(AwtMenu.this);
                    ((Status)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof MenuItem) {
                    AwtMenuItem item = new AwtMenuItem(AwtMenu.this);
                    ((MenuItem)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                }
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenu.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenu.this._native.setLabel(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        final int vKey = SwingUtil.getVirtualKey(menuItem.getShortcut());
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenu.this._native.setShortcut(new MenuShortcut(vKey));
            }
        });
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtMenu.this._native.removeAll();
                AwtMenu.this._native.deleteShortcut();
                AwtMenu.this._native.setEnabled(false);
                AwtMenu.this._native.removeNotify();
                if (AwtMenu.this.parent != null) {
                    ((AwtMenu)AwtMenu.this).parent._native.remove(AwtMenu.this._native);
                }
            }
        });
    }
}

