/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.jna.linux;

import com.sun.jna.Function;
import com.sun.jna.Pointer;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.jna.JnaHelper;
import dorkbox.systemTray.jna.linux.FuncCallback;
import dorkbox.systemTray.util.JavaFX;
import dorkbox.systemTray.util.Swt;
import dorkbox.util.OS;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Gtk {
    public static final boolean isGtk2;
    public static final boolean isGtk3;
    public static final boolean isLoaded;
    public static Function gtk_status_icon_position_menu;
    private static final boolean alreadyRunningGTK;
    private static ThreadLocal<Boolean> isDispatch;
    private static final int TIMEOUT = 2;
    private static volatile boolean started;
    private static final LinkedList<Object> gtkCallbacks;
    private static Thread gtkUpdateThread;
    public static final int FALSE = 0;
    public static final int TRUE = 1;

    public static void startGui() {
        if (!started) {
            started = true;
            if (!alreadyRunningGTK) {
                gtkUpdateThread = new Thread(){

                    @Override
                    public void run() {
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Running GTK Native Event Loop");
                        }
                        if (!Gtk.gtk_init_check(0)) {
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.error("Error starting GTK");
                            }
                            return;
                        }
                        Gtk.gtk_main();
                    }
                };
                gtkUpdateThread.setDaemon(false);
                gtkUpdateThread.setName("GTK Native Event Loop");
                gtkUpdateThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitForStartup() {
        final CountDownLatch blockUntilStarted = new CountDownLatch(1);
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                blockUntilStarted.countDown();
            }
        });
        if (SystemTray.isJavaFxLoaded) {
            if (JavaFX.isEventThread()) return;
            try {
                if (!blockUntilStarted.await(10L, TimeUnit.SECONDS) && SystemTray.DEBUG) {
                    SystemTray.logger.error("Something is very wrong. The waitForStartup took longer than expected.", new Exception(""));
                }
                while (true) {
                    Thread.sleep(100L);
                    LinkedList<Object> linkedList = gtkCallbacks;
                    synchronized (linkedList) {
                        if (gtkCallbacks.isEmpty()) {
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
        if (SystemTray.isSwtLoaded) {
            if (Swt.isEventThread()) return;
            try {
                if (!blockUntilStarted.await(10L, TimeUnit.SECONDS) && SystemTray.DEBUG) {
                    SystemTray.logger.error("Something is very wrong. The waitForStartup took longer than expected.", new Exception(""));
                }
                while (true) {
                    Thread.sleep(100L);
                    LinkedList<Object> e = gtkCallbacks;
                    synchronized (e) {
                        if (gtkCallbacks.isEmpty()) {
                            return;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            if (!blockUntilStarted.await(10L, TimeUnit.SECONDS) && SystemTray.DEBUG) {
                SystemTray.logger.error("Something is very wrong. The waitForStartup took longer than expected.", new Exception(""));
            }
            while (true) {
                Thread.sleep(100L);
                LinkedList<Object> e = gtkCallbacks;
                synchronized (e) {
                    if (gtkCallbacks.isEmpty()) {
                        return;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatch(final Runnable runnable) {
        if (alreadyRunningGTK) {
            if (SystemTray.isJavaFxLoaded) {
                if (JavaFX.isEventThread()) {
                    runnable.run();
                } else {
                    JavaFX.dispatch(runnable);
                }
                return;
            }
            if (SystemTray.isSwtLoaded && Swt.isEventThread()) {
                runnable.run();
                return;
            }
        }
        if (isDispatch.get().booleanValue()) {
            runnable.run();
        } else {
            FuncCallback callback = new FuncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int callback(Pointer data) {
                    LinkedList linkedList = gtkCallbacks;
                    synchronized (linkedList) {
                        gtkCallbacks.removeFirst();
                    }
                    isDispatch.set(true);
                    try {
                        runnable.run();
                    }
                    finally {
                        isDispatch.set(false);
                    }
                    return 0;
                }
            };
            LinkedList<Object> linkedList = gtkCallbacks;
            synchronized (linkedList) {
                gtkCallbacks.offer(callback);
            }
            Gtk.gdk_threads_add_idle_full(100, callback, null, null);
        }
    }

    public static void dispatchAndWait(final Runnable runnable) {
        block5: {
            if (isDispatch.get().booleanValue()) {
                runnable.run();
            } else {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                Gtk.dispatch(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            runnable.run();
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                });
                try {
                    if (countDownLatch.await(2L, TimeUnit.SECONDS)) break block5;
                    if (SystemTray.DEBUG) {
                        SystemTray.logger.error("Something is very wrong. The Event Dispatch Queue took longer than 2 seconds to complete.", new Exception(""));
                        break block5;
                    }
                    throw new RuntimeException("Something is very wrong. The Event Dispatch Queue took longer than 2 seconds to complete.");
                }
                catch (InterruptedException e) {
                    SystemTray.logger.error("Error waiting for dispatch to complete.", new Exception(""));
                }
            }
        }
    }

    public static void shutdownGui() {
        Gtk.dispatchAndWait(new Runnable(){

            @Override
            public void run() {
                if (!alreadyRunningGTK) {
                    Gtk.gtk_main_quit();
                }
                started = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void proxyClick(Entry menuEntry, ActionListener callback) {
        isDispatch.set(true);
        try {
            if (menuEntry != null) {
                callback.actionPerformed(new ActionEvent(menuEntry, 1001, ""));
            } else {
                callback.actionPerformed(null);
            }
        }
        finally {
            isDispatch.set(false);
        }
    }

    private static native boolean gtk_init_check(int var0);

    private static native void gtk_main();

    private static native int gtk_main_level();

    private static native void gtk_main_quit();

    public static native Pointer gtk_menu_new();

    public static native Pointer gtk_menu_item_set_submenu(Pointer var0, Pointer var1);

    public static native Pointer gtk_separator_menu_item_new();

    public static native Pointer gtk_image_new_from_file(String var0);

    public static native Pointer gtk_image_menu_item_new_with_mnemonic(String var0);

    public static native Pointer gtk_check_menu_item_new_with_mnemonic(String var0);

    public static native void gtk_check_menu_item_set_active(Pointer var0, boolean var1);

    public static native void gtk_image_menu_item_set_image(Pointer var0, Pointer var1);

    public static native void gtk_image_menu_item_set_always_show_image(Pointer var0, boolean var1);

    public static native Pointer gtk_status_icon_new();

    public static native void gtk_status_icon_set_from_file(Pointer var0, String var1);

    public static native void gtk_status_icon_set_visible(Pointer var0, boolean var1);

    public static native void gtk_status_icon_set_title(Pointer var0, String var1);

    public static native void gtk_status_icon_set_name(Pointer var0, String var1);

    public static native void gtk_menu_popup(Pointer var0, Pointer var1, Pointer var2, Function var3, Pointer var4, int var5, int var6);

    public static native void gtk_menu_item_set_label(Pointer var0, String var1);

    public static native void gtk_menu_shell_append(Pointer var0, Pointer var1);

    public static native void gtk_menu_shell_deactivate(Pointer var0);

    public static native void gtk_widget_set_sensitive(Pointer var0, boolean var1);

    public static native void gtk_widget_show_all(Pointer var0);

    public static native void gtk_container_remove(Pointer var0, Pointer var1);

    public static native void gtk_widget_destroy(Pointer var0);

    public static native int gdk_threads_add_idle_full(int var0, FuncCallback var1, Pointer var2, Pointer var3);

    static {
        boolean shouldLoadGtk;
        boolean _alreadyRunningGTK;
        boolean _isLoaded;
        boolean _isGtk2;
        block21: {
            String gtk2LibName;
            block20: {
                String gtk3LibName;
                block19: {
                    gtk_status_icon_position_menu = null;
                    isDispatch = new ThreadLocal<Boolean>(){

                        @Override
                        protected Boolean initialValue() {
                            return false;
                        }
                    };
                    boolean shouldUseGtk2 = SystemTray.FORCE_GTK2;
                    _isGtk2 = false;
                    _isLoaded = false;
                    _alreadyRunningGTK = false;
                    boolean bl = shouldLoadGtk = !OS.isWindows() && !OS.isMacOsX();
                    if (!shouldLoadGtk) {
                        _isLoaded = true;
                    }
                    if (!_isLoaded && SystemTray.FORCE_TRAY_TYPE == SystemTray.TrayType.Swing) {
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Forcing Swing tray, not using GTK");
                        }
                        _isLoaded = true;
                    }
                    gtk2LibName = "gtk-x11-2.0";
                    gtk3LibName = "libgtk-3.so.0";
                    if (!_isLoaded && shouldUseGtk2) {
                        try {
                            JnaHelper.register(gtk2LibName, Gtk.class);
                            gtk_status_icon_position_menu = Function.getFunction(gtk2LibName, "gtk_status_icon_position_menu");
                            _isGtk2 = true;
                            _alreadyRunningGTK = Gtk.gtk_main_level() != 0;
                            _isLoaded = true;
                            if (SystemTray.DEBUG) {
                                SystemTray.logger.debug("GTK: {}", (Object)gtk2LibName);
                            }
                        }
                        catch (Throwable e) {
                            if (!SystemTray.DEBUG) break block19;
                            SystemTray.logger.error("Error loading library", e);
                        }
                    }
                }
                if (!_isLoaded) {
                    try {
                        JnaHelper.register(gtk3LibName, Gtk.class);
                        gtk_status_icon_position_menu = Function.getFunction(gtk3LibName, "gtk_status_icon_position_menu");
                        _alreadyRunningGTK = Gtk.gtk_main_level() != 0;
                        _isLoaded = true;
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("GTK: {}", (Object)gtk3LibName);
                        }
                    }
                    catch (Throwable e) {
                        if (!SystemTray.DEBUG) break block20;
                        SystemTray.logger.error("Error loading library", e);
                    }
                }
            }
            if (!_isLoaded) {
                try {
                    JnaHelper.register(gtk2LibName, Gtk.class);
                    gtk_status_icon_position_menu = Function.getFunction(gtk2LibName, "gtk_status_icon_position_menu");
                    _isGtk2 = true;
                    _alreadyRunningGTK = Gtk.gtk_main_level() != 0;
                    _isLoaded = true;
                    if (SystemTray.DEBUG) {
                        SystemTray.logger.debug("GTK: {}", (Object)gtk2LibName);
                    }
                }
                catch (Throwable e) {
                    if (!SystemTray.DEBUG) break block21;
                    SystemTray.logger.error("Error loading library", e);
                }
            }
        }
        if (shouldLoadGtk && _isLoaded) {
            isLoaded = true;
            _alreadyRunningGTK |= SystemTray.isSwtLoaded;
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Is the system already running GTK? {}", (Object)_alreadyRunningGTK);
            }
            alreadyRunningGTK = _alreadyRunningGTK;
            isGtk2 = _isGtk2;
            isGtk3 = !_isGtk2;
        } else {
            isLoaded = false;
            alreadyRunningGTK = false;
            isGtk2 = false;
            isGtk3 = false;
        }
        if (shouldLoadGtk && !_isLoaded) {
            throw new RuntimeException("We apologize for this, but we are unable to determine the GTK library is in use, or even if it is in use... Please create an issue for this and include your OS type and configuration.");
        }
        started = false;
        gtkCallbacks = new LinkedList();
        gtkUpdateThread = null;
    }
}

