/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.util;

import at.gv.egiz.smcc.util.TLV;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TLVSequence
implements Iterable<TLV> {
    private byte[] bytes;

    public TLVSequence(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public Iterator<TLV> iterator() {
        return new TLVIterator();
    }

    public byte[] getValue(int n) {
        for (TLV tLV : this) {
            if (tLV.getTag() != n) continue;
            return tLV.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TLV tLV : this) {
            stringBuilder.append(tLV).append('\n');
        }
        return stringBuilder.toString();
    }

    private class TLVIterator
    implements Iterator<TLV> {
        private int pos = 0;

        private TLVIterator() {
        }

        @Override
        public boolean hasNext() {
            return TLVSequence.this.bytes.length - this.pos > 2;
        }

        @Override
        public TLV next() {
            if (this.hasNext()) {
                TLV tLV = new TLV(TLVSequence.this.bytes, this.pos);
                this.pos += 1 + tLV.getLengthFieldLength() + tLV.getLength();
                return tLV;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

