/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc.reader;

import at.gv.egiz.smcc.CancelledException;
import at.gv.egiz.smcc.ChangeReferenceDataAPDUSpec;
import at.gv.egiz.smcc.NewReferenceDataAPDUSpec;
import at.gv.egiz.smcc.PINConfirmationException;
import at.gv.egiz.smcc.PINFormatException;
import at.gv.egiz.smcc.PINOperationAbortedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.ResetRetryCounterAPDUSpec;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.ModifyPINGUI;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.reader.DefaultCardReader;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinpadCardReader
extends DefaultCardReader {
    public static final int PIN_ENTRY_POLLING_INTERVAL = 10;
    private final Logger log = LoggerFactory.getLogger(PinpadCardReader.class);
    protected byte bEntryValidationCondition = (byte)2;
    protected byte bTimeOut = (byte)60;
    protected byte bTimeOut2 = 0;
    protected byte wPINMaxExtraDigitMin = 0;
    protected byte wPINMaxExtraDigitMax = (byte)12;
    protected byte bNumberMessage = 1;
    protected Map<Byte, Integer> features;
    protected boolean VERIFY;
    protected boolean MODIFY;
    protected boolean VERIFY_DIRECT;
    protected boolean MODIFY_DIRECT;

    public PinpadCardReader(CardTerminal cardTerminal, Map<Byte, Integer> map) {
        super(cardTerminal);
        if (map == null) {
            throw new NullPointerException("Pinpad card reader does not support any features");
        }
        this.features = map;
        if (map.containsKey(FEATURE_VERIFY_PIN_START) && map.containsKey(FEATURE_GET_KEY_PRESSED) && map.containsKey(FEATURE_VERIFY_PIN_FINISH)) {
            this.VERIFY = true;
        }
        if (map.containsKey(FEATURE_MODIFY_PIN_START) && map.containsKey(FEATURE_GET_KEY_PRESSED) && map.containsKey(FEATURE_MODIFY_PIN_FINISH)) {
            this.MODIFY = true;
        }
        if (map.containsKey(FEATURE_VERIFY_PIN_DIRECT)) {
            this.VERIFY_DIRECT = true;
        }
        if (map.containsKey(FEATURE_MODIFY_PIN_DIRECT)) {
            this.MODIFY_DIRECT = true;
        }
        if (this.name != null) {
            this.name = this.name.toLowerCase();
            if (this.name.startsWith("gemplus gempc pinpad") || this.name.startsWith("gemalto gempc pinpad")) {
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    this.log.trace("Disabling direct pin entry as workaround for Windows");
                    this.VERIFY_DIRECT = false;
                    this.MODIFY_DIRECT = false;
                }
                this.log.trace("Setting custom wPINMaxExtraDigitH (0x04) for {}.", (Object)this.name);
                this.wPINMaxExtraDigitMin = (byte)4;
                this.log.trace("Setting custom wPINMaxExtraDigitL (0x08) for {}.", (Object)this.name);
                this.wPINMaxExtraDigitMax = (byte)8;
            } else if (this.name.startsWith("omnikey cardman 3621")) {
                this.log.trace("Setting custom wPINMaxExtraDigitH (0x01) for {}.", (Object)this.name);
                this.wPINMaxExtraDigitMin = 1;
            } else if (this.name.startsWith("scm spr 532") || this.name.startsWith("scm microsystems inc. sprx32 usb smart card reader")) {
                this.log.trace("Setting custom bTimeOut (0x3c) for {}.", (Object)this.name);
                this.bTimeOut = (byte)60;
                this.log.trace("Setting custom bTimeOut2 (0x0f) for {}.", (Object)this.name);
                this.bTimeOut2 = (byte)15;
            } else if (this.name.startsWith("cherry smartboard xx44")) {
                this.log.trace("Setting custom wPINMaxExtraDigitH (0x01) for {}.", (Object)this.name);
                this.wPINMaxExtraDigitMin = 1;
            } else if (this.name.startsWith("cherry gmbh smartterminal st-2xxx")) {
                this.log.trace("Setting custom bTimeOut (0x3c) for {}.", (Object)this.name);
                this.bTimeOut = (byte)60;
                this.log.trace("Setting custom bTimeOut2 (0x0f) for {}.", (Object)this.name);
                this.bTimeOut2 = (byte)15;
            }
        }
    }

    @Override
    public boolean hasFeature(Byte by) {
        return this.features.containsKey(by);
    }

    private void VERIFY_PIN_START(Card card, byte[] byArray) throws CardException {
        byte[] byArray2;
        int n = this.features.get(FEATURE_VERIFY_PIN_START);
        if (this.log.isTraceEnabled()) {
            this.log.trace("VERIFY_PIN_START ({}) {}", (Object)Integer.toHexString(n), (Object)SMCCHelper.toString(byArray));
        }
        if ((byArray2 = card.transmitControlCommand(n, byArray)) != null && byArray2.length > 0) {
            if (byArray2[0] == 87) {
                this.log.error("Invalid parameter in PIN_VERIFY structure.");
                throw new CardException("ERROR_INVALID_PARAMETER");
            }
            this.log.error("Unexpected response to VERIFY_PIN_START: {}.", (Object)SMCCHelper.toString(byArray2));
            throw new CardException("unexpected response to VERIFY_PIN_START: " + SMCCHelper.toString(byArray2));
        }
    }

    private byte GET_KEY_PRESSED(Card card) throws CardException {
        int n = this.features.get(FEATURE_GET_KEY_PRESSED);
        byte[] byArray = card.transmitControlCommand(n, new byte[0]);
        if (byArray != null && byArray.length == 1) {
            return byArray[0];
        }
        this.log.error("Unexpected response to GET_KEY_PRESSED: {}.", (Object)SMCCHelper.toString(byArray));
        throw new CardException("unexpected response to GET_KEY_PRESSED: " + SMCCHelper.toString(byArray));
    }

    private byte[] VERIFY_PIN_FINISH(Card card) throws CardException {
        byte[] byArray;
        int n = this.features.get(FEATURE_VERIFY_PIN_FINISH);
        if (this.log.isTraceEnabled()) {
            this.log.trace("VERIFY_PIN_FINISH ({})", (Object)Integer.toHexString(n));
        }
        if ((byArray = card.transmitControlCommand(n, new byte[0])) != null && byArray.length == 2) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("response {}", (Object)SMCCHelper.toString(byArray));
            }
            return byArray;
        }
        this.log.error("Unexpected response to VERIFY_PIN_FINISH: {}.", (Object)SMCCHelper.toString(byArray));
        throw new CardException("unexpected response to VERIFY_PIN_FINISH: " + SMCCHelper.toString(byArray));
    }

    private void MODIFY_PIN_START(Card card, byte[] byArray) throws CardException {
        byte[] byArray2;
        int n = this.features.get(FEATURE_MODIFY_PIN_START);
        if (this.log.isTraceEnabled()) {
            this.log.trace("MODFIY_PIN_START (" + Integer.toHexString(n) + ")  " + SMCCHelper.toString(byArray));
        }
        if ((byArray2 = card.transmitControlCommand(n, byArray)) != null && byArray2.length > 0) {
            if (byArray2[0] == 87) {
                this.log.error("Invalid parameter in PIN_MODIFY structure.");
                throw new CardException("ERROR_INVALID_PARAMETER");
            }
            this.log.error("Unexpected response to MODIFY_PIN_START: {}.", (Object)SMCCHelper.toString(byArray2));
            throw new CardException("unexpected response to MODIFY_PIN_START: " + SMCCHelper.toString(byArray2));
        }
    }

    private byte[] MODIFY_PIN_FINISH(Card card) throws CardException {
        byte[] byArray;
        int n = this.features.get(FEATURE_MODIFY_PIN_FINISH);
        if (this.log.isTraceEnabled()) {
            this.log.trace("MODIFY_PIN_FINISH ({})", (Object)Integer.toHexString(n));
        }
        if ((byArray = card.transmitControlCommand(n, new byte[0])) != null && byArray.length == 2) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("response {}", (Object)SMCCHelper.toString(byArray));
            }
            return byArray;
        }
        this.log.error("Unexpected response to MODIFY_PIN_FINISH: {}", (Object)SMCCHelper.toString(byArray));
        throw new CardException("unexpected response to MODIFY_PIN_FINISH: " + SMCCHelper.toString(byArray));
    }

    private byte[] VERIFY_PIN_DIRECT(Card card, byte[] byArray) throws CardException {
        int n = this.features.get(FEATURE_VERIFY_PIN_DIRECT);
        if (this.log.isTraceEnabled()) {
            this.log.trace("VERIFY_PIN_DIRECT ({}) {}", (Object)Integer.toHexString(n), (Object)SMCCHelper.toString(byArray));
        }
        byte[] byArray2 = card.transmitControlCommand(n, byArray);
        if (this.log.isTraceEnabled()) {
            this.log.trace("response {}", (Object)SMCCHelper.toString(byArray2));
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] verifyPin(Card card, byte[] byArray, PINGUI pINGUI) throws SignatureCardException, CardException, InterruptedException {
        block13: {
            byte by;
            this.log.debug("VERIFY_PIN_START [{}]", (Object)FEATURES[FEATURE_VERIFY_PIN_START]);
            this.VERIFY_PIN_START(card, byArray);
            while (true) {
                if ((by = this.GET_KEY_PRESSED(card)) == 0) {
                    PinpadCardReader pinpadCardReader = this;
                    synchronized (pinpadCardReader) {
                        try {
                            this.wait(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.log.error("interrupted in VERIFY_PIN");
                        }
                    }
                }
                if (by == 13) {
                    this.log.trace("GET_KEY_PRESSED: 0x0d (user confirmed)");
                    break block13;
                }
                if (by == 43) {
                    this.log.trace("GET_KEY_PRESSED: 0x2b (user entered valid key 0-9)");
                    pINGUI.validKeyPressed();
                    continue;
                }
                if (by == 27) {
                    this.log.trace("GET_KEY_PRESSED: 0x1b (user cancelled VERIFY_PIN via cancel button)");
                    break block13;
                }
                if (by == 8) {
                    this.log.trace("GET_KEY_PRESSED: 0x08 (user pressed correction/backspace button)");
                    pINGUI.correctionButtonPressed();
                    continue;
                }
                if (by == 14) {
                    this.log.trace("GET_KEY_PRESSED: 0x0e (timeout occured)");
                    break block13;
                }
                if (by == 64) {
                    this.log.trace("GET_KEY_PRESSED: 0x40 (PIN_Operation_Aborted)");
                    throw new PINOperationAbortedException("PIN_Operation_Aborted (0x40)");
                }
                if (by != 10) break;
                this.log.trace("GET_KEY_PRESSED: 0x0a (all keys cleared");
                pINGUI.allKeysCleared();
            }
            this.log.error("Unexpected response to GET_KEY_PRESSED: {}.", (Object)Integer.toHexString(by));
            throw new CardException("unexpected response to GET_KEY_PRESSED: " + Integer.toHexString(by));
        }
        return this.VERIFY_PIN_FINISH(card);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] modifyPin(Card card, byte[] byArray, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws PINOperationAbortedException, CardException {
        block16: {
            byte by;
            byte by2 = 0;
            byte by3 = byArray[9];
            this.log.debug("MODIFY_PIN_START [{}]", (Object)FEATURES[FEATURE_MODIFY_PIN_START]);
            this.MODIFY_PIN_START(card, byArray);
            while (true) {
                if ((by = this.GET_KEY_PRESSED(card)) == 0) {
                    PinpadCardReader pinpadCardReader = this;
                    synchronized (pinpadCardReader) {
                        try {
                            this.wait(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.log.error("Interrupted in MODIFY_PIN");
                        }
                    }
                }
                if (by == 13) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("requested pin confirmations: 0b{}", (Object)Integer.toBinaryString(by3 & 0xFF));
                        this.log.trace("performed pin confirmations: 0b{}", (Object)Integer.toBinaryString(by2 & 0xFF));
                    }
                    this.log.debug("GET_KEY_PRESSED: 0x0d (user confirmed)");
                    if (by2 != by3) {
                        if ((by3 & 2) == 0 || (by2 & 2) == 2) {
                            if ((by2 & 1) != 0) continue;
                            by2 = (byte)(by2 | 1);
                            modifyPINGUI.confirmNewPIN(pinInfo);
                            continue;
                        }
                        by2 = (byte)(by2 | 2);
                        modifyPINGUI.enterNewPIN(pinInfo);
                        continue;
                    }
                    break block16;
                }
                if (by == 43) {
                    this.log.trace("GET_KEY_PRESSED: 0x2b (user entered valid key 0-9)");
                    modifyPINGUI.validKeyPressed();
                    continue;
                }
                if (by == 27) {
                    this.log.trace("GET_KEY_PRESSED: 0x1b (user cancelled VERIFY_PIN via cancel button)");
                    break block16;
                }
                if (by == 8) {
                    this.log.trace("GET_KEY_PRESSED: 0x08 (user pressed correction/backspace button)");
                    modifyPINGUI.correctionButtonPressed();
                    continue;
                }
                if (by == 14) {
                    this.log.trace("GET_KEY_PRESSED: 0x0e (timeout occured)");
                    break block16;
                }
                if (by == 64) {
                    this.log.trace("GET_KEY_PRESSED: 0x40 (PIN_Operation_Aborted)");
                    throw new PINOperationAbortedException("PIN_Operation_Aborted (0x40)");
                }
                if (by != 10) break;
                this.log.trace("GET_KEY_PRESSED: 0x0a (all keys cleared");
                modifyPINGUI.allKeysCleared();
            }
            this.log.error("Unexpected response to GET_KEY_PRESSED: {}.", (Object)Integer.toHexString(by));
            throw new CardException("unexpected response to GET_KEY_PRESSED: " + Integer.toHexString(by));
        }
        modifyPINGUI.finish();
        return this.MODIFY_PIN_FINISH(card);
    }

    private byte[] MODIFY_PIN_DIRECT(Card card, byte[] byArray) throws CardException {
        int n = this.features.get(FEATURE_MODIFY_PIN_DIRECT);
        if (this.log.isTraceEnabled()) {
            this.log.trace("MODIFY_PIN_DIRECT ({}) {}", (Object)Integer.toHexString(n), (Object)SMCCHelper.toString(byArray));
        }
        byte[] byArray2 = card.transmitControlCommand(n, byArray);
        if (this.log.isTraceEnabled()) {
            this.log.trace("response {}", (Object)SMCCHelper.toString(byArray2));
        }
        return byArray2;
    }

    protected byte[] createPINModifyStructure(NewReferenceDataAPDUSpec newReferenceDataAPDUSpec, PinInfo pinInfo) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.bTimeOut);
        byteArrayOutputStream.write(this.bTimeOut2);
        byteArrayOutputStream.write(0x80 | (0xF & newReferenceDataAPDUSpec.getPinPosition()) << 3 | 1 & newReferenceDataAPDUSpec.getPinJustification() << 2 | 3 & newReferenceDataAPDUSpec.getPinFormat());
        byteArrayOutputStream.write((0xF & newReferenceDataAPDUSpec.getPinLengthSize()) << 4 | 0xF & newReferenceDataAPDUSpec.getPinLength());
        byteArrayOutputStream.write(0xF & newReferenceDataAPDUSpec.getPinLengthPos());
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(newReferenceDataAPDUSpec.getPinInsertionOffsetNew());
        byteArrayOutputStream.write(Math.min(pinInfo.getMaxLength(), this.wPINMaxExtraDigitMax));
        byteArrayOutputStream.write(Math.max(pinInfo.getMinLength(), this.wPINMaxExtraDigitMin));
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(this.bEntryValidationCondition);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(9);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(newReferenceDataAPDUSpec.getApdu().length);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        try {
            byteArrayOutputStream.write(newReferenceDataAPDUSpec.getApdu());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] createPINModifyStructure(ChangeReferenceDataAPDUSpec changeReferenceDataAPDUSpec, PinInfo pinInfo) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.bTimeOut);
        byteArrayOutputStream.write(this.bTimeOut2);
        byteArrayOutputStream.write(0x80 | (0xF & changeReferenceDataAPDUSpec.getPinPosition()) << 3 | 1 & changeReferenceDataAPDUSpec.getPinJustification() << 2 | 3 & changeReferenceDataAPDUSpec.getPinFormat());
        byteArrayOutputStream.write((0xF & changeReferenceDataAPDUSpec.getPinLengthSize()) << 4 | 0xF & changeReferenceDataAPDUSpec.getPinLength());
        byteArrayOutputStream.write(0xF & changeReferenceDataAPDUSpec.getPinLengthPos());
        byteArrayOutputStream.write(changeReferenceDataAPDUSpec.getPinInsertionOffsetOld());
        byteArrayOutputStream.write(changeReferenceDataAPDUSpec.getPinInsertionOffsetNew());
        byteArrayOutputStream.write(Math.min(pinInfo.getMaxLength(), this.wPINMaxExtraDigitMax));
        byteArrayOutputStream.write(Math.max(pinInfo.getMinLength(), this.wPINMaxExtraDigitMin));
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(this.bEntryValidationCondition);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(9);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(2);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(changeReferenceDataAPDUSpec.getApdu().length);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        try {
            byteArrayOutputStream.write(changeReferenceDataAPDUSpec.getApdu());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] createPINVerifyStructure(VerifyAPDUSpec verifyAPDUSpec, PinInfo pinInfo) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.bTimeOut);
        byteArrayOutputStream.write(this.bTimeOut2);
        byteArrayOutputStream.write(0x80 | (0xF & verifyAPDUSpec.getPinPosition()) << 3 | 1 & verifyAPDUSpec.getPinJustification() << 2 | 3 & verifyAPDUSpec.getPinFormat());
        byteArrayOutputStream.write((0xF & verifyAPDUSpec.getPinLengthSize()) << 4 | 0xF & verifyAPDUSpec.getPinLength());
        byteArrayOutputStream.write(0xF & verifyAPDUSpec.getPinLengthPos());
        byteArrayOutputStream.write(Math.min(pinInfo.getMaxLength(), this.wPINMaxExtraDigitMax));
        byteArrayOutputStream.write(Math.max(pinInfo.getMinLength(), this.wPINMaxExtraDigitMin));
        byteArrayOutputStream.write(this.bEntryValidationCondition);
        byteArrayOutputStream.write(this.bNumberMessage);
        byteArrayOutputStream.write(9);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(verifyAPDUSpec.getApdu().length);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        try {
            byteArrayOutputStream.write(verifyAPDUSpec.getApdu());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU verify(CardChannel cardChannel, VerifyAPDUSpec verifyAPDUSpec, PINGUI pINGUI, PinInfo pinInfo, int n) throws SignatureCardException, CardException, InterruptedException {
        ResponseAPDU responseAPDU = null;
        byte[] byArray = this.createPINVerifyStructure(verifyAPDUSpec, pinInfo);
        Card card = cardChannel.getCard();
        if (this.VERIFY) {
            boolean bl = this.dropExclusive(card);
            try {
                pINGUI.enterPIN(pinInfo, n);
                responseAPDU = new ResponseAPDU(this.verifyPin(card, byArray, pINGUI));
            }
            finally {
                this.regainExclusive(card, bl);
            }
        } else if (this.VERIFY_DIRECT) {
            boolean bl = this.dropExclusive(card);
            try {
                pINGUI.enterPINDirect(pinInfo, n);
                this.log.debug("VERIFY_PIN_DIRECT [{}]", (Object)FEATURES[FEATURE_VERIFY_PIN_DIRECT]);
                responseAPDU = new ResponseAPDU(this.VERIFY_PIN_DIRECT(card, byArray));
            }
            finally {
                this.regainExclusive(card, bl);
            }
        } else {
            this.log.warn("Falling back to default pin-entry.");
            return super.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        }
        switch (responseAPDU.getSW()) {
            case 25600: {
                this.log.debug("SPE operation timed out.");
                throw new TimeoutException();
            }
            case 25601: {
                this.log.debug("SPE operation was cancelled by the 'Cancel' button.");
                throw new CancelledException();
            }
            case 25603: {
                this.log.debug("User entered too short or too long PIN regarding MIN/MAX PIN length.");
                throw new PINFormatException();
            }
            case 25728: {
                this.log.debug("SPE operation was aborted by the 'Cancel' operation at the host system.");
            }
            case 27520: {
                this.log.info("Invalid parameter in passed structure.");
            }
        }
        return responseAPDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU modify(CardChannel cardChannel, ChangeReferenceDataAPDUSpec changeReferenceDataAPDUSpec, ModifyPINGUI modifyPINGUI, PinInfo pinInfo, int n) throws SignatureCardException, CardException, InterruptedException {
        ResponseAPDU responseAPDU = null;
        byte[] byArray = this.createPINModifyStructure(changeReferenceDataAPDUSpec, pinInfo);
        Card card = cardChannel.getCard();
        if (this.MODIFY) {
            boolean bl = this.dropExclusive(card);
            try {
                modifyPINGUI.enterCurrentPIN(pinInfo, n);
                responseAPDU = new ResponseAPDU(this.modifyPin(card, byArray, modifyPINGUI, pinInfo));
            }
            finally {
                this.regainExclusive(card, bl);
            }
        } else if (this.MODIFY_DIRECT) {
            boolean bl = this.dropExclusive(card);
            try {
                modifyPINGUI.modifyPINDirect(pinInfo, n);
                this.log.debug("MODIFY_PIN_DIRECT [{}]", (Object)FEATURES[FEATURE_MODIFY_PIN_DIRECT]);
                responseAPDU = new ResponseAPDU(this.MODIFY_PIN_DIRECT(card, byArray));
            }
            finally {
                this.regainExclusive(card, bl);
            }
        } else {
            this.log.warn("Falling back to default pin-entry.");
            return super.modify(cardChannel, changeReferenceDataAPDUSpec, modifyPINGUI, pinInfo, n);
        }
        switch (responseAPDU.getSW()) {
            case 25600: {
                this.log.debug("SPE operation timed out.");
                throw new TimeoutException();
            }
            case 25601: {
                this.log.debug("SPE operation was cancelled by the 'Cancel' button.");
                throw new CancelledException();
            }
            case 25602: {
                this.log.debug("Modify PIN operation failed because two 'new PIN' entries do not match");
                throw new PINConfirmationException();
            }
            case 25603: {
                this.log.debug("User entered too short or too long PIN regarding MIN/MAX PIN length.");
                throw new PINFormatException();
            }
            case 25728: {
                this.log.debug("SPE operation was aborted by the 'Cancel' operation at the host system.");
            }
            case 27520: {
                this.log.info("Invalid parameter in passed structure.");
            }
        }
        return responseAPDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAPDU modify(CardChannel cardChannel, NewReferenceDataAPDUSpec newReferenceDataAPDUSpec, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws SignatureCardException, CardException, InterruptedException {
        ResponseAPDU responseAPDU = null;
        byte[] byArray = this.createPINModifyStructure(newReferenceDataAPDUSpec, pinInfo);
        Card card = cardChannel.getCard();
        if (this.MODIFY) {
            boolean bl = this.dropExclusive(card);
            try {
                modifyPINGUI.enterNewPIN(pinInfo);
                responseAPDU = new ResponseAPDU(this.modifyPin(card, byArray, modifyPINGUI, pinInfo));
            }
            finally {
                this.regainExclusive(card, bl);
            }
        } else if (this.MODIFY_DIRECT) {
            boolean bl = this.dropExclusive(card);
            try {
                modifyPINGUI.modifyPINDirect(pinInfo, -1);
                this.log.debug("MODIFY_PIN_DIRECT [{}]", (Object)FEATURES[FEATURE_MODIFY_PIN_DIRECT]);
                responseAPDU = new ResponseAPDU(this.MODIFY_PIN_DIRECT(card, byArray));
            }
            finally {
                this.regainExclusive(card, bl);
            }
        } else {
            this.log.warn("Falling back to default pin-entry.");
            return super.modify(cardChannel, newReferenceDataAPDUSpec, modifyPINGUI, pinInfo);
        }
        switch (responseAPDU.getSW()) {
            case 25600: {
                this.log.debug("SPE operation timed out.");
                throw new TimeoutException();
            }
            case 25601: {
                this.log.debug("SPE operation was cancelled by the 'Cancel' button.");
                throw new CancelledException();
            }
            case 25602: {
                this.log.debug("Modify PIN operation failed because two 'new PIN' entries do not match");
                throw new PINConfirmationException();
            }
            case 25603: {
                this.log.debug("User entered too short or too long PIN regarding MIN/MAX PIN length.");
                throw new PINFormatException();
            }
            case 25728: {
                this.log.debug("SPE operation was aborted by the 'Cancel' operation at the host system.");
            }
            case 27520: {
                this.log.info("Invalid parameter in passed structure.");
            }
        }
        return responseAPDU;
    }

    @Override
    public ResponseAPDU modify(CardChannel cardChannel, ResetRetryCounterAPDUSpec resetRetryCounterAPDUSpec, ModifyPINGUI modifyPINGUI, PinInfo pinInfo, int n) throws InterruptedException, CardException, SignatureCardException {
        return this.modify(cardChannel, (ChangeReferenceDataAPDUSpec)resetRetryCounterAPDUSpec, modifyPINGUI, pinInfo, n);
    }

    private boolean dropExclusive(Card card) throws CardException {
        this.log.debug("Dropping exclusive card access");
        try {
            card.endExclusive();
        }
        catch (IllegalStateException illegalStateException) {
            this.log.debug("Didn't have exclusive access");
            return false;
        }
        return true;
    }

    private void regainExclusive(Card card, boolean bl) throws CardException {
        if (bl) {
            this.log.debug("Trying to regain exclusive card access");
            card.beginExclusive();
        }
    }
}

