/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuisseIDCard
extends AbstractSignatureCard
implements SignatureCard {
    private final Logger log = LoggerFactory.getLogger(SuisseIDCard.class);
    public static final byte[] MF = new byte[]{63, 0};
    public static final byte[] AID_SIG = new byte[]{-46, 118, 0, 0, 102, 1};
    public static final byte[] PATH_SIGN_CERT = new byte[]{63, 0, 80, 21, 67, 4, 67, 5};
    public static final byte KID = -127;
    protected PinInfo pinInfo;
    protected String name = "SuisseID";

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
        super.init(card, cardTerminal);
        byte[] byArray = card.getATR().getBytes();
        if (byArray[11] == 83 && byArray[12] == 119 && byArray[13] == 105 && byArray[14] == 115 && byArray[15] == 115 && byArray[16] == 83 && byArray[17] == 105 && byArray[18] == 103 && byArray[19] == 110) {
            this.name = "SwissSign SuisseID";
            this.pinInfo = new PinInfo(5, 12, "[0-9a-zA-Z^\u00b0!\"\u00a7$%&/()=?`\u00b4{}\\[\\]\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df+*~#',;\\.:\\-_@<>|]", "at/gv/egiz/smcc/SwissSignIDCard", "pin", -127, AID_SIG, -1);
        } else {
            this.name = "QuoVadis SuisseID";
            this.pinInfo = new PinInfo(6, 12, "[0-9]", "at/gv/egiz/smcc/QuoVadisIDCard", "pin", -127, AID_SIG, -1);
        }
        this.log.debug("initializing {} for ATR {}", (Object)this.name, (Object)this.toString(byArray));
    }

    public String toString() {
        return this.name;
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException {
        if (keyboxName != SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR) {
            throw new IllegalArgumentException("Keybox " + keyboxName + " not supported");
        }
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_PATH(cardChannel, PATH_SIGN_CERT);
            byte[] byArray = ISO7816Utils.readTransparentFileTLV(cardChannel, -1, (byte)48);
            if (byArray == null) {
                throw new NotActivatedException();
            }
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        if (SignatureCard.KeyboxName.SECURE_SIGNATURE_KEYPAIR != keyboxName) {
            throw new SignatureCardException("Card does not support key " + keyboxName + ".");
        }
        if (!"http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
            throw new SignatureCardException("Card does not support algorithm " + string + ".");
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
            throw new SignatureCardException(noSuchAlgorithmException);
        }
        byte[] byArray = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        byArray = messageDigest.digest();
        byte[] byArray2 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new SignatureCardException(iOException);
        }
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_AID(cardChannel, AID_SIG);
            this.execMSE_RESOTRE(cardChannel, 1);
            this.verifyPINLoop(cardChannel, this.pinInfo, pINGUI);
            return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel, byteArrayOutputStream.toByteArray());
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID()}, 0, 2, 0);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -1;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    protected byte[] execSELECT_AID(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, 4, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found AID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected byte[] execSELECT_PATH(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        int n = byArray.length > 1 && byArray[0] == 63 && byArray[1] == 0 ? 8 : 9;
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 164, n, 0, byArray, 256));
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found PATH=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select PATH=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
        return responseAPDU.getBytes();
    }

    protected void execMSE_RESOTRE(CardChannel cardChannel, int n) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 34, 243, n));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("MSE:RESTORE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected byte[] execPSO_COMPUTE_DIGITAL_SIGNATURE(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, byArray, 256));
        if (responseAPDU.getSW() == 27010) {
            throw new SecurityStatusNotSatisfiedException();
        }
        if (responseAPDU.getSW() == 27011) {
            throw new LockedException();
        }
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO: COMPUTE DIGITAL SIGNATURE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }
}

