/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.CardNotSupportedException;
import at.gv.egiz.smcc.ExclSignatureCardProxy;
import at.gv.egiz.smcc.SWCard;
import at.gv.egiz.smcc.SignatureCard;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureCardFactory {
    public static boolean ENFORCE_RECOMMENDED_PIN_LENGTH = false;
    private final Logger log = LoggerFactory.getLogger(SignatureCardFactory.class);
    private static SignatureCardFactory instance;
    private List<SupportedCard> supportedCards = new ArrayList<SupportedCard>();

    public static synchronized SignatureCardFactory getInstance() {
        if (instance == null) {
            instance = new SignatureCardFactory();
        }
        return instance;
    }

    private SignatureCardFactory() {
        this.supportedCards.add(new SupportedCard(new byte[]{59, -67, 24, 0, -127, 49, -2, 69, -128, 81, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "at.gv.egiz.smcc.STARCOSCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -35, -106, -1, -127, -79, -2, 69, 31, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "at.gv.egiz.smcc.STARCOSCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -33, 24, 0, -127, 49, -2, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "at.gv.egiz.smcc.STARCOSCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -33, 24, 0, -127, 49, -2, 88, -128, 49, -112, 82, 65, 1, 100, 5, -55, 3, -84, 115, -73, -79, -44, 68}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "at.gv.egiz.smcc.STARCOSCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -65, 17, 0, -127, 49, -2, 69, 69, 80, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "at.gv.egiz.smcc.ACOSCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -65, 17, 0, -127, 49, -2, 69, 77, 67, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, "at.gv.egiz.smcc.ACOSCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -104, 19, 64, 10, -91, 3, 1, 1, 1, -83, 19, 17}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.BELPICCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -104, -108, 64, -1, -91, 3, 1, 1, 1, -83, 19, 16}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.BELPICCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -104, -108, 64, 10, -91, 3, 1, 1, 1, -83, 19, 16}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.BELPICCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -104, -107, 64, 10, -91, 7, 1, 1, 1, -83, 19, 32}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.BELPICCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -35, 24, 0, -127, 49, -2, 69, -128, -7, -96, 0, 0, 0, 119, 1, 8, 0, 7, -112, 0, -2}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.CypriotEID"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 22, -106, 65, 115, 116, 114, 105, 100}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.GemaltoNetV2_0Card"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 127, 56, 0, 0, 0, 106, 68, 78, 73, 101, 0, 2, 76, 52, 1, 19, 0, -112, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 0, -1, -1}, "at.gv.egiz.smcc.ESDNIeCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 123, -108, 0, 0, -128, 98, 0, 81, 86, 70, 105, 110, 69, 73, 68}, new byte[]{70, 105, 110, 69, 73, 68}, new byte[]{-1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.FINEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 125, -108, 0, 0, -128, 49, -128, 101, -80, -125, 17, -64, -87, -125, 0, -112, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.LtEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -97, -112, -128, 31, -64, 0, 104, 0, 0, 5, 0, 70, 73, 83, 69, 49, -56, 0, 0, 0, 0}, new byte[]{-1, -1, -16, -1, -1, -16, -1, -1, 0, 0, -1, -16, -1, -1, -1, -1, -1, -1, -16, 0, 0, 0}, "at.gv.egiz.smcc.SEIdentityCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 104, 0, 0, 0, 115, -56, 64, 16, 0, -112, 0}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.ISVISAElectronCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 111, 0, 0, -128, 49, -32, 107, 4, 32, 5, 2, 88, 85, 85, 85, 85, 85, 85}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.ISMAESTROCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -1, 24, 0, -1, -127, 49, -2, 85, 0, 107, 2, 9}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -1, 24, 0, -1, -63, 10, 49, -2, 85, 0, 107, 5, 8, -56, 5, 1, 1, 1, 67, 78, 83, 16, 49, -128, 28}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -33, 24, 0, -127, 49, -2, 125, 0, 107, 21, 12, 1, -127, 1, 1, 1, 67, 78, 83, 16, 49, -128, -8}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, -127, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, -113, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, -127, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, -113, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, -127, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, -113, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, -15, 0, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, -1, 0, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, -127, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, -113, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, -127, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, -113, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, -127, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, -113, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, -15, 0, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, -1, 0, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, 0, -127, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, 0, -113, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, 0, -127, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, 0, -113, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, 0, -127, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, 0, -113, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -113, 0, 0, -15, 0, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -113, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -1, 0, 0, 0, -127, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -1, 0, 0, 0, -113, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -1, 0, 0, 0, -127, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -1, 0, 0, 0, -113, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -1, 0, 0, 0, -127, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -1, 0, 0, 0, -113, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -1, 0, 0, 0, -15, 0, 0, 0, 49, 0, 0, 0, 107, 0, 0, 0, 0, 1, 0, 0, 67, 78, 83, 16, 49, -128, 0}, new byte[]{-1, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, -1, 0, -16, -1, -1, -1, -1, -1, -1, 0}, "at.gv.egiz.smcc.ITCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 0, 0, 0, 69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48}, new byte[]{69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48}, new byte[]{-1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.EstEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -34, 24, -1, -64, -128, -79, -2, 69, 31, 3, 69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48, 43}, new byte[]{69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.EstEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -2, -108, 0, -1, -128, -79, -6, 69, 31, 3, 69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48, 67}, new byte[]{69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.EstEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -2, 24, 0, 0, -128, 49, -2, 69, 69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48, -88}, new byte[]{69, 115, 116, 69, 73, 68, 32, 118, 101, 114, 32, 49, 46, 48}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.EstEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -2, 24, 0, 0, -128, 49, -2, 69, -128, 49, -128, 102, 64, -112, -92, 22, 42, 0, -125, 1, -112, 0, -31}, new byte[]{-128, 49, -128, 102, 64, -112, -92, 22, 42, 0, -125, 1, -112, 0, -31}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.EstEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -2, 24, 0, 0, -128, 49, -2, 69, -128, 49, -128, 102, 64, -112, -92, 22, 42, 0, -125, 15, -112, 0, -17}, new byte[]{-128, 49, -128, 102, 64, -112, -92, 22, 42, 0, -125, 1, -112, 0, -17}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.EstEIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 125, -107, 0, 0, -128, 49, -128, 101, -80, -125, 17, -64, -87, -125, 0, -112, 0}, new byte[]{-1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0}, "at.gv.egiz.smcc.PtEidCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, 125, -107, 0, 0, -128, 49, -128, 101, -80, -125, 17, 0, -56, -125, 0, -112, 0}, new byte[]{-1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, 0}, "at.gv.egiz.smcc.PtEidCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -6, 24, 0, 2, -63, 10, 49, -2, 88, 75, 83, 119, 105, 115, 115, 83, 105, 103, 110, -119}, new byte[]{83, 119, 105, 115, 115, 83, 105, 103, 110}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.SuisseIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -14, 24, 0, 2, -63, 10, 49, -2, 88, -56, 8, 116}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.SuisseIDCard"));
        this.supportedCards.add(new SupportedCard(new byte[]{59, -69, 24, 0, -64, 16, 49, -2, 69, -128, 103, 4, 18, -80, 3, 3, 0, 0, -127, 5, 60}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, "at.gv.egiz.smcc.LIEZertifikatCard"));
    }

    public SignatureCard createSignatureCard(Card card, CardTerminal cardTerminal) throws CardNotSupportedException {
        if (card == null) {
            SWCard sWCard = new SWCard();
            sWCard.init(card, cardTerminal);
            return sWCard;
        }
        ATR aTR = card.getATR();
        for (SupportedCard object2 : this.supportedCards) {
            if (!object2.matches(aTR)) continue;
            return this.instantiateSignatureCard(cardTerminal, card, object2);
        }
        this.log.trace("No card matching complete ATR found - checking candidates with historical bytes matches.");
        Iterator<SupportedCard> iterator = this.supportedCards.iterator();
        List<SupportedCard> list = new ArrayList<SupportedCard>();
        while (iterator.hasNext()) {
            SupportedCard supportedCard = iterator.next();
            if (!supportedCard.matchesHistoricalBytesPattern(aTR)) continue;
            list.add(supportedCard);
        }
        if ((list = this.reduceCandidateList(list)).size() == 1) {
            this.log.trace("Instantiating class " + list.get(0).getImplementationClassName() + " according to historical bytes pattern match.");
            return this.instantiateSignatureCard(cardTerminal, card, list.get(0));
        }
        this.log.warn("Found {} cards with matching historical bytes pattern.", (Object)list.size());
        throw new CardNotSupportedException("Card not supported: ATR=" + SignatureCardFactory.toString(aTR.getBytes()));
    }

    private SignatureCard instantiateSignatureCard(CardTerminal cardTerminal, Card card, SupportedCard supportedCard) throws CardNotSupportedException {
        ClassLoader classLoader = SignatureCardFactory.class.getClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(supportedCard.getImplementationClassName());
            SignatureCard signatureCard = (SignatureCard)clazz.newInstance();
            signatureCard = ExclSignatureCardProxy.newInstance(signatureCard);
            signatureCard.init(card, cardTerminal);
            return signatureCard;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.warn("Cannot find signature card implementation class.", classNotFoundException);
            throw new CardNotSupportedException("Cannot find signature card implementation class.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.log.warn("Failed to instantiate signature card implementation.", instantiationException);
            throw new CardNotSupportedException("Failed to instantiate signature card implementation.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.warn("Failed to instantiate signature card implementation.", illegalAccessException);
            throw new CardNotSupportedException("Failed to instantiate signature card implementation.", illegalAccessException);
        }
    }

    private List<SupportedCard> reduceCandidateList(List<SupportedCard> list) {
        ArrayList<SupportedCard> arrayList = new ArrayList<SupportedCard>();
        for (SupportedCard supportedCard : list) {
            String string = supportedCard.getImplementationClassName();
            boolean bl = false;
            for (SupportedCard supportedCard2 : arrayList) {
                if (!supportedCard2.getImplementationClassName().equals(string)) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(supportedCard);
        }
        return arrayList;
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null && byArray.length > 0) {
            stringBuffer.append(Integer.toHexString((byArray[0] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[0] & 0xF));
        }
        for (int i = 1; i < byArray.length; ++i) {
            stringBuffer.append(':');
            stringBuffer.append(Integer.toHexString((byArray[i] & 0xF0) >> 4));
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    private class SupportedCard {
        private byte[] atrPattern;
        private byte[] atrMask;
        private byte[] historicalBytesPattern;
        private String impl;

        public SupportedCard(byte[] byArray, byte[] byArray2, String string) {
            if (byArray.length != byArray2.length) {
                throw new IllegalArgumentException("Length of 'atr' and 'mask' must be equal.");
            }
            this.atrPattern = byArray;
            this.atrMask = byArray2;
            this.impl = string;
        }

        public SupportedCard(byte[] byArray, byte[] byArray2, byte[] byArray3, String string) {
            this(byArray, byArray3, string);
            this.historicalBytesPattern = byArray2;
        }

        public boolean matches(ATR aTR) {
            byte[] byArray = aTR.getBytes();
            if (byArray == null) {
                return false;
            }
            if (byArray.length < this.atrMask.length) {
                return false;
            }
            int n = Math.min(this.atrMask.length, byArray.length);
            for (int i = 0; i < n; ++i) {
                if ((byArray[i] & this.atrMask[i]) == this.atrPattern[i]) continue;
                return false;
            }
            return true;
        }

        public boolean matchesHistoricalBytesPattern(ATR aTR) {
            byte[] byArray = aTR.getHistoricalBytes();
            if (byArray == null || this.historicalBytesPattern == null || this.historicalBytesPattern.length > byArray.length) {
                return false;
            }
            int[] nArray = this.computeFailure(this.historicalBytesPattern);
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                while (n > 0 && this.historicalBytesPattern[n] != byArray[i]) {
                    n = nArray[n - 1];
                }
                if (this.historicalBytesPattern[n] == byArray[i]) {
                    ++n;
                }
                if (n != this.historicalBytesPattern.length) continue;
                return true;
            }
            return false;
        }

        private int[] computeFailure(byte[] byArray) {
            int[] nArray = new int[byArray.length];
            int n = 0;
            for (int i = 1; i < byArray.length; ++i) {
                while (n > 0 && byArray[n] != byArray[i]) {
                    n = nArray[n - 1];
                }
                if (byArray[n] == byArray[i]) {
                    // empty if block
                }
                nArray[i] = ++n;
            }
            return nArray;
        }

        public String getImplementationClassName() {
            return this.impl;
        }
    }
}

