/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.LtEIDCIOCertificate;
import at.gv.egiz.smcc.LtEIDCIOCertificateDirectory;
import at.gv.egiz.smcc.LtEIDCIOKey;
import at.gv.egiz.smcc.LtEIDCIOKeyDirectory;
import at.gv.egiz.smcc.LtEIDObjectDirectory;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.cio.CIOCertificate;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtEIDCard
extends AbstractSignatureCard
implements SignatureCard {
    private static final byte[] AID = new byte[]{-96, 0, 0, 0, 24, 12, 0, 0, 1, 99, 66, 0};
    private static final String CERT_LABEL_IDENTIFIER = "DigitalSignature";
    private static final PinInfo QS_PIN_SPEC = new PinInfo(8, 8, ".", "at/gv/egiz/smcc/LtEIDCard", "qs.pin", -127, AID, -1);
    private final Logger log = LoggerFactory.getLogger(LtEIDCard.class);

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.selectApplication(cardChannel);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error selecting AID.", cardException);
        }
        try {
            byte[] byArray = null;
            LtEIDObjectDirectory ltEIDObjectDirectory = new LtEIDObjectDirectory();
            ltEIDObjectDirectory.selectAndRead(cardChannel);
            if (ltEIDObjectDirectory.getCDReferences() == null || ltEIDObjectDirectory.getCDReferences().size() < 1) {
                throw new SignatureCardException("EF.CD not found - cannot get certificate information.");
            }
            LtEIDCIOCertificateDirectory ltEIDCIOCertificateDirectory = new LtEIDCIOCertificateDirectory(ltEIDObjectDirectory.getCDReferences().get(0));
            ltEIDCIOCertificateDirectory.selectAndRead(cardChannel);
            List<CIOCertificate> list = ltEIDCIOCertificateDirectory.getCIOs();
            LtEIDCIOCertificate ltEIDCIOCertificate = null;
            for (CIOCertificate object2 : list) {
                if (!(object2 instanceof LtEIDCIOCertificate) || !object2.getLabel().contains(CERT_LABEL_IDENTIFIER)) continue;
                ltEIDCIOCertificate = (LtEIDCIOCertificate)object2;
                byArray = ltEIDCIOCertificate.getiD();
            }
            this.log.debug("Starting real PIN Verification..");
            this.verifyPINLoop(cardChannel, QS_PIN_SPEC, pINGUI);
            if (ltEIDObjectDirectory.getPrKDReferences() == null || ltEIDObjectDirectory.getPrKDReferences().size() < 1) {
                throw new SignatureCardException("EF.PrKD not found - cannot get key information.");
            }
            List<byte[]> list2 = ltEIDObjectDirectory.getPrKDReferences();
            LtEIDCIOKeyDirectory ltEIDCIOKeyDirectory = new LtEIDCIOKeyDirectory(ltEIDObjectDirectory.getPrKDReferences().get(0));
            ltEIDCIOKeyDirectory.selectAndRead(cardChannel);
            LtEIDCIOKey ltEIDCIOKey = null;
            for (LtEIDCIOKey ltEIDCIOKey2 : ltEIDCIOKeyDirectory.getKeys()) {
                if (byArray == null || !Arrays.equals(ltEIDCIOKey2.getID(), byArray)) continue;
                ltEIDCIOKey = ltEIDCIOKey2;
            }
            if (ltEIDCIOKey == null) {
                throw new SignatureCardException("Unable to determine required key information.");
            }
            this.execMSESet(cardChannel, ltEIDCIOKey.getKeyReference().intValue());
            this.execPSOHash(cardChannel, inputStream);
            return this.execPSOComputeDigitalSignature(cardChannel);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error creating signature.", cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.selectApplication(cardChannel);
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error selecting AID.", cardException);
        }
        LtEIDObjectDirectory ltEIDObjectDirectory = new LtEIDObjectDirectory();
        try {
            ltEIDObjectDirectory.selectAndRead(cardChannel);
            if (ltEIDObjectDirectory.getCDReferences() == null || ltEIDObjectDirectory.getCDReferences().size() < 1) {
                throw new SignatureCardException("EF.CD not found - cannot get certificate information.");
            }
            LtEIDCIOCertificateDirectory ltEIDCIOCertificateDirectory = new LtEIDCIOCertificateDirectory(ltEIDObjectDirectory.getCDReferences().get(0));
            ltEIDCIOCertificateDirectory.selectAndRead(cardChannel);
            List<CIOCertificate> list = ltEIDCIOCertificateDirectory.getCIOs();
            LtEIDCIOCertificate ltEIDCIOCertificate = null;
            for (CIOCertificate object2 : list) {
                if (!(object2 instanceof LtEIDCIOCertificate) || !object2.getLabel().contains(CERT_LABEL_IDENTIFIER)) continue;
                ltEIDCIOCertificate = (LtEIDCIOCertificate)object2;
            }
            if (ltEIDCIOCertificate == null) {
                throw new SignatureCardException("Unable to determine signature certificate.");
            }
            if (ltEIDCIOCertificate.getOffset() == null || ltEIDCIOCertificate.getLength() == null || ltEIDCIOCertificate.getEfidOrPath() == null) {
                throw new SignatureCardException("Unable to retrieve required certificate information.");
            }
            Object object3 = this.selectFile(cardChannel, ltEIDCIOCertificate.getEfidOrPath());
            byte[] byArray = this.executeReadBinary(cardChannel, ISO7816Utils.getLengthFromFCx((byte[])object3));
            byte[] byArray2 = new byte[this.toInt(ltEIDCIOCertificate.getLength())];
            System.arraycopy(byArray, ltEIDCIOCertificate.getOffset().intValue(), byArray2, 0, byArray2.length);
            return byArray2;
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Unable to retrieve certificate from card.", cardException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SignatureCardException("Unable to retrieve certificate from card.", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new SignatureCardException("Unable to retrieve certificate from card.", iOException);
        }
    }

    private void execMSESet(CardChannel cardChannel, int n) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 34, 65, -74, new byte[]{-128, 1, 18, -124, 1, (byte)n});
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error executing MSE-SET. Unexpected response: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void execPSOHash(CardChannel cardChannel, InputStream inputStream) throws SignatureCardException {
        Object object;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
            throw new SignatureCardException(noSuchAlgorithmException);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            object = new byte[messageDigest.getDigestLength()];
            while ((n = inputStream.read((byte[])object)) != -1) {
                messageDigest.update((byte[])object, 0, n);
            }
            object = messageDigest.digest();
            byteArrayOutputStream.write(new byte[]{-112, 20});
            byteArrayOutputStream.write((byte[])object);
        }
        catch (IOException iOException) {
            throw new SignatureCardException("Error computing hash.", iOException);
        }
        try {
            object = new CommandAPDU(0, 42, -112, -96, byteArrayOutputStream.toByteArray());
            ResponseAPDU responseAPDU = cardChannel.transmit((CommandAPDU)object);
            this.log.debug("Answer to PSO-HASH: " + Integer.toHexString(responseAPDU.getSW()));
            if (responseAPDU.getSW() != 36864) {
                throw new SignatureCardException("Error setting hash. Unexpected answer from card: " + Integer.toHexString(responseAPDU.getSW()));
            }
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error setting hash.", cardException);
        }
    }

    private byte[] execPSOComputeDigitalSignature(CardChannel cardChannel) throws SignatureCardException {
        CommandAPDU commandAPDU = new CommandAPDU(new byte[]{0, 42, -98, -102, 0});
        try {
            ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
            this.log.debug("Answer to PSO-Compute Digital Signature: " + Integer.toHexString(responseAPDU.getSW()));
            if (responseAPDU.getSW() != 36864) {
                throw new SignatureCardException("Error computing signature. Unexpected answer from card: " + Integer.toHexString(responseAPDU.getSW()));
            }
            return responseAPDU.getData();
        }
        catch (CardException cardException) {
            throw new SignatureCardException("Error computing signature.", cardException);
        }
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) >= -1) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID(), 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 0, 2, 16);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -2;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 25344: {
                return -1;
            }
            case 25600: {
                throw new TimeoutException();
            }
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    private void selectApplication(CardChannel cardChannel) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 4, 0, AID);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error selecting AID - unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private byte[] selectFile(CardChannel cardChannel, byte[] byArray) throws CardException {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length > 2 && byArray[0] == 63 && byArray[1] == 0) {
            byArray2 = new byte[byArray.length - 2];
            System.arraycopy(byArray, 2, byArray2, 0, byArray.length - 2);
        } else {
            byArray2 = byArray;
        }
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 8, 0, byArray2);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            throw new CardException("Error selecting File - unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private byte[] executeReadBinary(CardChannel cardChannel, int n) throws CardException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (!bl) {
            n4 = n - n2 > 239 ? 239 : n - n2;
            byte[] byArray = SMCCHelper.toByteArray(n3);
            ResponseAPDU responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)n4);
            if (responseAPDU.getSW1() == 108) {
                responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)responseAPDU.getSW2());
                bl = true;
            }
            try {
                byteArrayOutputStream.write(responseAPDU.getData());
            }
            catch (IOException iOException) {
                this.log.error("Error executing secure read binary.", iOException);
                throw new CardException("Error reading data from card", iOException);
            }
            n3 = n2 += responseAPDU.getData().length;
            if (n2 != n) continue;
            bl = true;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private ResponseAPDU readFromCard(CardChannel cardChannel, byte by, byte by2, byte by3) throws CardException {
        byte[] byArray = new byte[]{0, -80, by, by2, by3};
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        return responseAPDU;
    }

    private int toInt(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            n2 = (int)((double)n2 + (double)byArray[i] * Math.pow(256.0, n - i - 1));
        }
        return n2;
    }
}

