/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.InfoboxException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class Infobox {
    private int tag;
    private byte[] data;
    private byte[] encryptedKey;

    public Infobox(int n, int n2, byte[] byArray) throws InfoboxException {
        this.tag = n;
        if ((n2 & 0xFE) > 0) {
            throw new InfoboxException("Infobox modifiers " + Integer.toBinaryString(n2) + " not supported.");
        }
        if ((n2 & 1) > 0) {
            int n3 = (0xFF & byArray[0]) + ((0xFF & byArray[1]) << 8);
            this.encryptedKey = new byte[n3];
            System.arraycopy(byArray, 2, this.encryptedKey, 0, n3);
            int n4 = byArray.length - 2 - n3;
            this.data = new byte[n4];
            System.arraycopy(byArray, 2 + this.encryptedKey.length, this.data, 0, n4);
        } else {
            this.data = byArray;
        }
    }

    public Infobox(byte[] byArray) {
        this.data = byArray;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean isEncrypted() {
        return this.encryptedKey != null;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public byte[] decipher(byte[] byArray) throws InfoboxException {
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            byte[] byArray2 = new byte[8];
            Arrays.fill(byArray2, (byte)0);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DESede");
            algorithmParameters.init(ivParameterSpec);
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            cipher.init(2, (Key)secretKey, algorithmParameters);
            return cipher.doFinal(this.data);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InfoboxException("Failed to decipher Infobox.", generalSecurityException);
        }
    }
}

