/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.CancelledException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PINFormatException;
import at.gv.egiz.smcc.PINMgmtSignatureCard;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.pin.gui.ModifyPINGUI;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.MSCMException;
import at.gv.egiz.smcc.util.MSCMService;
import iaik.me.security.CryptoBag;
import iaik.me.security.CryptoException;
import iaik.me.security.MessageDigest;
import iaik.me.security.cipher.TripleDES;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.rsa.RSAPadding;

public class GemaltoNetV2_0Card
extends AbstractSignatureCard
implements PINMgmtSignatureCard {
    private static final String KSC_PATTERN = "ksc(\\p{XDigit}\\p{XDigit})";
    private static final String CERT_FILE = "mscp\\ksc";
    private static final String CONTAINER_00 = "00";
    private static final String CONTAINER_01 = "01";
    private static final String CONTAINER_02 = "02";
    private static final String CONTAINER_03 = "03";
    private static final String CONTAINER_04 = "04";
    private static final String CONTAINER_05 = "05";
    private static final String CONTAINER_06 = "06";
    private static final String CONTAINER_07 = "07";
    private static final String CONTAINER_08 = "08";
    private static final String CONTAINER_09 = "09";
    private static final String CONTAINER_10 = "10";
    private static final String CONTAINER_11 = "11";
    private static final String CONTAINER_12 = "12";
    private static final String CONTAINER_13 = "13";
    private static final String CONTAINER_14 = "14";
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_00 = SignatureCard.KeyboxName.getKeyboxName("00");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_01 = SignatureCard.KeyboxName.getKeyboxName("01");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_02 = SignatureCard.KeyboxName.getKeyboxName("02");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_03 = SignatureCard.KeyboxName.getKeyboxName("03");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_04 = SignatureCard.KeyboxName.getKeyboxName("04");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_05 = SignatureCard.KeyboxName.getKeyboxName("05");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_06 = SignatureCard.KeyboxName.getKeyboxName("06");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_07 = SignatureCard.KeyboxName.getKeyboxName("07");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_08 = SignatureCard.KeyboxName.getKeyboxName("08");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_09 = SignatureCard.KeyboxName.getKeyboxName("09");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_10 = SignatureCard.KeyboxName.getKeyboxName("10");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_11 = SignatureCard.KeyboxName.getKeyboxName("11");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_12 = SignatureCard.KeyboxName.getKeyboxName("12");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_13 = SignatureCard.KeyboxName.getKeyboxName("13");
    private static final SignatureCard.KeyboxName KEYBOX_CONTAINER_14 = SignatureCard.KeyboxName.getKeyboxName("14");
    private final Logger log = LoggerFactory.getLogger(GemaltoNetV2_0Card.class);
    PinInfo pinPinInfo;
    PinInfo pukPinInfo;
    Pattern pattern;
    private final byte[] SHA1_PADDING = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private final byte[] SHA256_PADDING = new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};

    @Override
    public void init(Card card, CardTerminal cardTerminal) {
        super.init(card, cardTerminal);
        this.pattern = Pattern.compile(KSC_PATTERN);
        this.log.info("GemaltoNetV2 card found");
        this.pinPinInfo = new PinInfo(4, 64, "[0-9]", "at/gv/egiz/smcc/GemaltoNetV2_0Card", "sig.pin", 1, new byte[0], 5);
        this.pukPinInfo = new PinInfo(48, 48, "[0-9A-F]", "at/gv/egiz/smcc/GemaltoNetV2_0Card", "sig.puk", 2, new byte[0], 3);
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    private int findKeyIndex() throws IOException, CardException, MSCMException {
        MSCMService mSCMService = new MSCMService(this.getCardChannel());
        String[] stringArray = mSCMService.getFiles("mscp");
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.log.trace("Checking file: " + stringArray[i]);
            Matcher matcher = this.pattern.matcher(string);
            if (!matcher.find() || matcher.groupCount() != 1) continue;
            String string2 = matcher.group(1);
            this.log.trace("Found idx: " + string2);
            try {
                int n2 = Integer.parseInt(string2, 16);
                if (n >= n2) continue;
                n = n2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warn("Matched Regex but is no integer!", numberFormatException);
            }
        }
        return n;
    }

    private String getCertificateFileFormIdx(int n) {
        return String.format("%s%02x", CERT_FILE, n);
    }

    private int resolveKeyboxIdx(SignatureCard.KeyboxName keyboxName) {
        if (keyboxName.equals(KEYBOX_CONTAINER_00)) {
            return 0;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_01)) {
            return 1;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_02)) {
            return 2;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_03)) {
            return 3;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_04)) {
            return 4;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_05)) {
            return 5;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_06)) {
            return 6;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_07)) {
            return 7;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_08)) {
            return 8;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_09)) {
            return 9;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_10)) {
            return 10;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_11)) {
            return 11;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_12)) {
            return 12;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_13)) {
            return 13;
        }
        if (keyboxName.equals(KEYBOX_CONTAINER_14)) {
            return 14;
        }
        return -1;
    }

    private String resolveKeybox(SignatureCard.KeyboxName keyboxName) {
        int n = this.resolveKeyboxIdx(keyboxName);
        if (n < 0) {
            return null;
        }
        return this.getCertificateFileFormIdx(n);
    }

    @Override
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        try {
            byte[] byArray;
            CardChannel cardChannel = this.getCardChannel();
            MSCMService mSCMService = new MSCMService(cardChannel);
            String string = this.resolveKeybox(keyboxName);
            if (string == null) {
                int n = this.findKeyIndex();
                if (n < 0) {
                    throw new SignatureCardException("There is no certificate available on this token!");
                }
                string = this.getCertificateFileFormIdx(n);
            }
            this.log.info("Reading certificate: " + string);
            byte[] byArray2 = mSCMService.readFile(string);
            Inflater inflater = new Inflater();
            inflater.setInput(byArray2, 4, byArray2.length - 4);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (!inflater.finished()) {
                byArray = new byte[1024];
                int n = inflater.inflate(byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
        catch (DataFormatException dataFormatException) {
            this.log.info("Failed to get certificate.", dataFormatException);
            throw new SignatureCardException(dataFormatException);
        }
        catch (IOException iOException) {
            this.log.info("Failed to get certificate.", iOException);
            throw new SignatureCardException(iOException);
        }
        catch (MSCMException mSCMException) {
            this.log.info("Failed to get certificate.", mSCMException);
            throw new SignatureCardException(mSCMException);
        }
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        return this.getCertificate(SignatureCard.KeyboxName.getKeyboxName(string), pINGUI);
    }

    @Override
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        int n2;
        boolean bl;
        block13: {
            bl = false;
            n2 = -1;
            try {
                n2 = this.resolveKeyboxIdx(keyboxName);
                if (n2 < 0 && (n2 = this.findKeyIndex()) < 0) {
                    throw new SignatureCardException("There is no private key available on this token!");
                }
                if (n2 > 14) {
                    this.log.error("Key Index is bigger the maximum container available");
                    throw new SignatureCardException("There is no private key available on this token!");
                }
                this.log.info("Signing with key: " + n2);
                if (string == null || "http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
                    messageDigest = MessageDigest.getInstance("SHA-1");
                    bl = true;
                    break block13;
                }
                if ("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256".equals(string)) {
                    messageDigest = MessageDigest.getInstance("SHA-256");
                    break block13;
                }
                throw new SignatureCardException("Card does not support signature algorithm " + string + ".");
            }
            catch (CryptoException cryptoException) {
                this.log.error("Failed to get MessageDigest.", cryptoException);
                throw new SignatureCardException(cryptoException);
            }
            catch (CardException cardException) {
                this.log.error("Failed to get MessageDigest.", cardException);
                throw new SignatureCardException(cardException);
            }
            catch (MSCMException mSCMException) {
                this.log.error("Failed to get MessageDigest.", mSCMException);
                throw new SignatureCardException(mSCMException);
            }
        }
        byte[] byArray = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        byArray = messageDigest.digest();
        try {
            RSAPadding rSAPadding = RSAPadding.getInstance(1, 256);
            CardChannel cardChannel = this.getCardChannel();
            MSCMService mSCMService = new MSCMService(cardChannel);
            this.verifyPINLoop(cardChannel, this.pinPinInfo, pINGUI);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (bl) {
                byteArrayOutputStream.write(this.SHA1_PADDING);
            } else {
                byteArrayOutputStream.write(this.SHA256_PADDING);
            }
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byte[] byArray3 = rSAPadding.pad(byArray2);
            byte[] byArray4 = mSCMService.privateKeyDecrypt((byte)n2, (byte)2, byArray3);
            return byArray4;
        }
        catch (Throwable throwable) {
            this.log.warn("Failed to execute command.", throwable);
            throw new SignatureCardException("Failed to access card.", throwable);
        }
    }

    protected void unblockPINLoop(CardChannel cardChannel, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        int n = -1;
        while ((n = this.exec_unblockPIN(cardChannel, modifyPINGUI, pinInfo)) > 0) {
        }
    }

    protected int exec_unblockPIN(CardChannel cardChannel, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        char[] cArray = modifyPINGUI.providePUK(pinInfo, this.pukPinInfo, this.pukPinInfo.retries);
        char[] cArray2 = modifyPINGUI.provideNewPIN(pinInfo);
        byte[] byArray = this.encodePIN(cArray2);
        MSCMService mSCMService = new MSCMService(cardChannel);
        try {
            byte[] byArray2 = GemaltoNetV2_0Card.hexStringToByteArray(new String(cArray));
            if (byArray2.length != 24) {
                throw new SignatureCardException("Invalid ADMIN PIN (not 24 bytes long)!");
            }
            byte[] byArray3 = mSCMService.getChallenge();
            byte[] byArray4 = mSCMService.cryptoResponse(byArray3, byArray2);
            mSCMService.unblockPIN((byte)1, byArray4, byArray, pinInfo.maxRetries);
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        catch (IOException iOException) {
            String string = "SET PIN failed.";
            this.log.info(string);
            pinInfo.setUnknown();
            throw new SignatureCardException(string, iOException);
        }
        catch (MSCMException mSCMException) {
            this.log.info(mSCMException.getMessage());
            try {
                return mSCMService.getTriesRemaining((byte)2);
            }
            catch (IOException iOException) {
                String string = "getTriesRemaining failed.";
                this.log.info(string);
                pinInfo.setUnknown();
                throw new SignatureCardException(string, iOException);
            }
            catch (MSCMException mSCMException2) {
                String string = "getTriesRemaining failed.";
                this.log.info(string);
                pinInfo.setUnknown();
                throw new SignatureCardException(string, mSCMException2);
            }
        }
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws InterruptedException, CardException, SignatureCardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected int verifyPUK(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws InterruptedException, CardException, SignatureCardException {
        char[] cArray = pINGUI.providePIN(pinInfo, pinInfo.retries);
        byte[] byArray = GemaltoNetV2_0Card.hexStringToByteArray(new String(cArray));
        if (byArray.length != 24) {
            throw new SignatureCardException("Invalid ADMIN PIN (not 24 bytes long)!");
        }
        MSCMService mSCMService = new MSCMService(cardChannel);
        try {
            byte[] byArray2 = mSCMService.getChallenge();
            byte[] byArray3 = mSCMService.cryptoResponse(byArray2, byArray);
            mSCMService.doExternalAuthentication(byArray3);
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        catch (MSCMException mSCMException) {
            try {
                int n2 = mSCMService.getTriesRemaining(pinInfo.getKID());
                pinInfo.setActive(n2);
                return n2;
            }
            catch (Exception exception) {
                this.log.error("Failed to get remaining tries");
                throw new SignatureCardException(exception);
            }
        }
        catch (IOException iOException) {
            this.log.error("Failed to verify PIN");
            throw new SignatureCardException(iOException);
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws InterruptedException, CardException, SignatureCardException {
        char[] cArray = pINGUI.providePIN(pinInfo, pinInfo.retries);
        byte[] byArray = this.encodePIN(cArray);
        MSCMService mSCMService = new MSCMService(cardChannel);
        try {
            mSCMService.verifyPin(pinInfo.getKID(), byArray);
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        catch (MSCMException mSCMException) {
            try {
                int n2 = mSCMService.getTriesRemaining(pinInfo.getKID());
                if (n2 == 0) {
                    pinInfo.setBlocked();
                    throw new LockedException();
                }
                pinInfo.setActive(n2);
                return n2;
            }
            catch (IOException iOException) {
                this.log.error("Failed to get remaining tries");
                throw new SignatureCardException(iOException);
            }
            catch (MSCMException mSCMException2) {
                this.log.error("Failed to get remaining tries");
                throw new SignatureCardException(mSCMException2);
            }
        }
        catch (IOException iOException) {
            this.log.error("Failed to verify PIN");
            throw new SignatureCardException(iOException);
        }
    }

    protected void changePINLoop(CardChannel cardChannel, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        int n = -1;
        while ((n = pinInfo.getKID() == 2 ? this.exec_changePUK(cardChannel, modifyPINGUI, pinInfo) : this.exec_changePIN(cardChannel, modifyPINGUI, pinInfo)) > 0) {
        }
    }

    protected byte[] cryptoChallenge(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            TripleDES tripleDES = new TripleDES();
            tripleDES.init(1, CryptoBag.makeSecretKey(byArray2), CryptoBag.makeIV(byArray3), null);
            this.log.info("Crypto IV: " + MSCMService.bytArrayToHex(tripleDES.getIV().getEncoded()));
            byte[] byArray4 = tripleDES.doFinal(byArray);
            this.log.info("Crypto result: " + MSCMService.bytArrayToHex(byArray4));
            return byArray4;
        }
        catch (CryptoException cryptoException) {
            this.log.error("Failed to get crypto stuff", cryptoException);
            return null;
        }
    }

    protected int exec_changePUK(CardChannel cardChannel, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        char[] cArray = modifyPINGUI.providePUK(pinInfo, this.pukPinInfo, this.pukPinInfo.retries);
        char[] cArray2 = modifyPINGUI.provideNewPIN(pinInfo);
        MSCMService mSCMService = new MSCMService(cardChannel);
        try {
            byte[] byArray = GemaltoNetV2_0Card.hexStringToByteArray(new String(cArray));
            byte[] byArray2 = GemaltoNetV2_0Card.hexStringToByteArray(new String(cArray2));
            if (byArray.length != 24) {
                throw new SignatureCardException("Invalid ADMIN PIN (not 24 bytes long)!");
            }
            if (byArray2.length != 24) {
                throw new SignatureCardException("Invalid ADMIN PIN (not 24 bytes long)!");
            }
            byte[] byArray3 = mSCMService.getChallenge();
            byte[] byArray4 = mSCMService.cryptoResponse(byArray3, byArray);
            mSCMService.changePIN((byte)2, byArray4, byArray2, pinInfo.maxRetries);
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        catch (IOException iOException) {
            String string = "SET PIN failed.";
            this.log.info(string);
            pinInfo.setUnknown();
            throw new SignatureCardException(string, iOException);
        }
        catch (MSCMException mSCMException) {
            this.log.info(mSCMException.getMessage());
            try {
                int n = mSCMService.getTriesRemaining(pinInfo.getKID());
                if (n == 0) {
                    pinInfo.setBlocked();
                    throw new LockedException();
                }
                pinInfo.setActive(n);
                return n;
            }
            catch (IOException iOException) {
                String string = "getTriesRemaining failed.";
                this.log.info(string);
                pinInfo.setUnknown();
                throw new SignatureCardException(string, iOException);
            }
            catch (MSCMException mSCMException2) {
                String string = "getTriesRemaining failed.";
                this.log.info(string);
                pinInfo.setUnknown();
                throw new SignatureCardException(string, mSCMException2);
            }
        }
    }

    protected int exec_changePIN(CardChannel cardChannel, ModifyPINGUI modifyPINGUI, PinInfo pinInfo) throws InterruptedException, CardException, SignatureCardException {
        char[] cArray = modifyPINGUI.providePUK(pinInfo, this.pinPinInfo, this.pinPinInfo.retries);
        char[] cArray2 = modifyPINGUI.provideNewPIN(pinInfo);
        byte[] byArray = this.encodePIN(cArray);
        byte[] byArray2 = this.encodePIN(cArray2);
        MSCMService mSCMService = new MSCMService(cardChannel);
        try {
            mSCMService.changePIN((byte)1, byArray, byArray2, pinInfo.maxRetries);
            pinInfo.setActive(pinInfo.maxRetries);
            return -1;
        }
        catch (IOException iOException) {
            String string = "SET PIN failed.";
            this.log.info(string);
            pinInfo.setUnknown();
            throw new SignatureCardException(string, iOException);
        }
        catch (MSCMException mSCMException) {
            this.log.info(mSCMException.getMessage());
            try {
                int n = mSCMService.getTriesRemaining(pinInfo.getKID());
                if (n == 0) {
                    pinInfo.setBlocked();
                    throw new LockedException();
                }
                pinInfo.setActive(n);
                return n;
            }
            catch (IOException iOException) {
                String string = "getTriesRemaining failed.";
                this.log.info(string);
                pinInfo.setUnknown();
                throw new SignatureCardException(string, iOException);
            }
            catch (MSCMException mSCMException2) {
                String string = "getTriesRemaining failed.";
                this.log.info(string);
                pinInfo.setUnknown();
                throw new SignatureCardException(string, mSCMException2);
            }
        }
    }

    private byte[] encodePIN(char[] cArray) {
        return Charset.forName("ASCII").encode(CharBuffer.wrap(cArray)).array();
    }

    @Override
    public PinInfo[] getPinInfos() throws SignatureCardException {
        return new PinInfo[]{this.pinPinInfo, this.pukPinInfo};
    }

    @Override
    public void verifyPIN(PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, CancelledException, SignatureCardException, InterruptedException {
        try {
            CardChannel cardChannel = this.getCardChannel();
            if (pinInfo.getKID() == 2) {
                this.verifyPUK(cardChannel, pinInfo, pINGUI, pinInfo.retries);
            } else {
                this.verifyPIN(cardChannel, pinInfo, pINGUI, pinInfo.retries);
            }
        }
        catch (CardException cardException) {
            this.log.error("Failed to verify PIN");
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    public void changePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws LockedException, NotActivatedException, CancelledException, PINFormatException, SignatureCardException, InterruptedException {
        try {
            this.changePINLoop(this.getCardChannel(), modifyPINGUI, pinInfo);
        }
        catch (CardException cardException) {
            this.log.error("Failed to change PIN");
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    public void activatePIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, InterruptedException {
        this.log.error("ACTIVATE PIN not supported by Cypriotic EID");
        throw new SignatureCardException("PIN activation not supported by this card.");
    }

    @Override
    public void unblockPIN(PinInfo pinInfo, ModifyPINGUI modifyPINGUI) throws CancelledException, SignatureCardException, InterruptedException {
        if (pinInfo.getKID() == 2) {
            throw new SignatureCardException("Unable to unblock PUK");
        }
        CardChannel cardChannel = this.getCardChannel();
        try {
            this.unblockPINLoop(cardChannel, modifyPINGUI, pinInfo);
        }
        catch (CardException cardException) {
            this.log.info("Failed to unblock PIN.", cardException);
            throw new SignatureCardException("Failed to unblock PIN.", cardException);
        }
    }
}

