/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.TimeoutException;
import at.gv.egiz.smcc.VerifyAPDUSpec;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstEIDCard
extends AbstractSignatureCard {
    private final Logger log = LoggerFactory.getLogger(EstEIDCard.class);
    public static final byte KID_PIN_2 = 2;
    public static final byte[] DF = new byte[]{-18, -18};
    public static final byte[] EF_CERT = new byte[]{-35, -50};
    public static final byte[] MF = new byte[]{63, 0};
    private static final PinInfo QS_PIN_SPEC = new PinInfo(5, 12, "[0-9]", "at/gv/egiz/smcc/EstEIDCard", "qs.pin", 2, DF, -1);

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_MF(cardChannel);
            this.execSELECT_DF(cardChannel, DF);
            this.execSELECT_EF(cardChannel, EF_CERT);
            byte[] byArray = ISO7816Utils.readTransparentFileTLV(cardChannel, -1, (byte)48);
            if (byArray == null) {
                throw new NotActivatedException();
            }
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Failed to get certificate.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        int n;
        MessageDigest messageDigest;
        if (!"http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(string)) {
            throw new SignatureCardException("Card does not support algorithm " + string + ".");
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
            throw new SignatureCardException(noSuchAlgorithmException);
        }
        byte[] byArray = new byte[messageDigest.getDigestLength()];
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        byArray = messageDigest.digest();
        try {
            CardChannel cardChannel = this.getCardChannel();
            this.execSELECT_MF(cardChannel);
            this.execSELECT_DF(cardChannel, DF);
            this.execMSE(cardChannel, 243, 1, null);
            this.verifyPINLoop(cardChannel, QS_PIN_SPEC, pINGUI);
            return this.execPSO_COMPUTE_DIGITAL_SIGNATURE(cardChannel, byArray);
        }
        catch (CardException cardException) {
            this.log.warn("Failed to execute command.", cardException);
            throw new SignatureCardException("Failed to access card.", cardException);
        }
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) >= -1) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        VerifyAPDUSpec verifyAPDUSpec = new VerifyAPDUSpec(new byte[]{0, 32, 0, pinInfo.getKID()}, 0, 2, 0);
        ResponseAPDU responseAPDU = this.reader.verify(cardChannel, verifyAPDUSpec, pINGUI, pinInfo, n);
        if (responseAPDU.getSW() == 36864) {
            return -2;
        }
        if (responseAPDU.getSW() >> 4 == 1596) {
            return 0xF & responseAPDU.getSW();
        }
        switch (responseAPDU.getSW()) {
            case 25344: {
                return -1;
            }
            case 25600: {
                throw new TimeoutException();
            }
            case 27011: {
                throw new LockedException();
            }
            case 27012: {
                throw new NotActivatedException();
            }
            case 27013: {
                throw new NotActivatedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(responseAPDU.getSW());
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    protected void execSELECT_MF(CardChannel cardChannel) throws SignatureCardException, CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -92, 0, 12);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() == 27266) {
            String string = "Master file not found. SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select master file. SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
    }

    protected void execSELECT_DF(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        this.execSELECT(cardChannel, 1, 4, byArray);
    }

    protected void execSELECT_EF(CardChannel cardChannel, byte[] byArray) throws SignatureCardException, CardException {
        this.execSELECT(cardChannel, 2, 4, byArray);
    }

    protected void execSELECT(CardChannel cardChannel, int n, int n2, byte[] byArray) throws SignatureCardException, CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 164, n, n2, byArray, 256);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() == 27266) {
            String string = "File or application not found FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.info(string);
            throw new FileNotFoundException(string);
        }
        if (responseAPDU.getSW() != 36864) {
            String string = "Failed to select application FID=" + SMCCHelper.toString(byArray) + " SW=" + Integer.toHexString(responseAPDU.getSW()) + ".";
            this.log.error(string);
            throw new SignatureCardException(string);
        }
    }

    protected void execMSE(CardChannel cardChannel, int n, int n2, byte[] byArray) throws CardException, SignatureCardException {
        ResponseAPDU responseAPDU = byArray == null ? cardChannel.transmit(new CommandAPDU(0, 34, n, n2)) : cardChannel.transmit(new CommandAPDU(0, 34, n, n2, byArray));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("MSE:SET failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    protected byte[] execPSO_COMPUTE_DIGITAL_SIGNATURE(CardChannel cardChannel, byte[] byArray) throws CardException, SignatureCardException {
        byte[] byArray2 = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new SignatureCardException(iOException);
        }
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(0, 42, 158, 154, byteArrayOutputStream.toByteArray(), 128));
        if (responseAPDU.getSW() != 36864) {
            throw new SignatureCardException("PSO: COMPUTE DIGITAL SIGNATURE failed: SW=" + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }
}

