/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.AbstractSignatureCard;
import at.gv.egiz.smcc.DNIeCIOCertificateDirectory;
import at.gv.egiz.smcc.DNIeSecuredChannel;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.LockedException;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.PinInfo;
import at.gv.egiz.smcc.SignatureCard;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.cio.CIOCertificate;
import at.gv.egiz.smcc.cio.ObjectDirectory;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESDNIeCard
extends AbstractSignatureCard
implements SignatureCard {
    public static final byte[] MASTER_FILE_ID = new byte[]{77, 97, 115, 116, 101, 114, 46, 70, 105, 108, 101};
    private final byte[] HASH_PADDING = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private final String SIG_KEY_NAME = "KprivFirmaDigital";
    private final String SIG_CERT_NAME = "CertFirmaDigital";
    private final Logger log = LoggerFactory.getLogger(ESDNIeCard.class);
    protected PinInfo pinInfo = new PinInfo(8, 16, "[0-9A-Za-z_<>!()?%\\-=&+\\.]", "at/gv/egiz/smcc/ESDNIeCard", "sig.pin", 0, new byte[0], -1);

    @Override
    protected CardChannel getCardChannel() {
        return new DNIeSecuredChannel(this.getCard().getBasicChannel());
    }

    @Override
    @Exclusive
    public byte[] createSignature(InputStream inputStream, SignatureCard.KeyboxName keyboxName, PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException, IOException {
        CardChannel cardChannel = this.getCardChannel();
        try {
            int n;
            this.executeSelectMasterFile(cardChannel);
            this.executeSelectDFCIA(cardChannel);
            ObjectDirectory objectDirectory = new ObjectDirectory();
            objectDirectory.selectAndRead(cardChannel);
            DNIeCIOCertificateDirectory dNIeCIOCertificateDirectory = new DNIeCIOCertificateDirectory(objectDirectory.getPrKDReferences().get(0));
            dNIeCIOCertificateDirectory.selectAndRead(cardChannel);
            byte[] byArray = null;
            for (CIOCertificate object2 : dNIeCIOCertificateDirectory.getCIOs()) {
                String string2 = object2.getLabel();
                if (string2 == null || !string2.toLowerCase().contains("KprivFirmaDigital".toLowerCase())) continue;
                byArray = object2.getEfidOrPath();
            }
            if (byArray == null) {
                throw new NotActivatedException();
            }
            this.verifyPINLoop(cardChannel, this.pinInfo, pINGUI);
            if (byArray == null || byArray.length < 2) {
                throw new CardException("Unable to determine valid key path. Key path either null or unexpected length.");
            }
            Object object3 = new byte[2];
            object3[0] = byArray[byArray.length - 2];
            object3[1] = byArray[byArray.length - 1];
            this.executeManageSecurityEnvironment(cardChannel, (byte[])object3);
            try {
                object3 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log.error("Failed to get MessageDigest.", noSuchAlgorithmException);
                throw new SignatureCardException(noSuchAlgorithmException);
            }
            byte[] byArray2 = new byte[((MessageDigest)object3).getDigestLength()];
            while ((n = inputStream.read(byArray2)) != -1) {
                ((MessageDigest)object3).update(byArray2, 0, n);
            }
            byte[] byArray3 = ((MessageDigest)object3).digest();
            return this.executeCreateSignature(cardChannel, byArray3);
        }
        catch (CardException cardException) {
            this.log.error("Error during signature creation.", cardException);
            throw new SignatureCardException("Error creating signature with DNIe card.", cardException);
        }
    }

    @Override
    @Exclusive
    public byte[] getCertificate(SignatureCard.KeyboxName keyboxName, PINGUI pINGUI) throws SignatureCardException, InterruptedException {
        byte[] byArray = null;
        CardChannel cardChannel = this.getCardChannel();
        byte[] byArray2 = null;
        try {
            this.executeSelectMasterFile(cardChannel);
            this.executeSelectDFCIA(cardChannel);
            byte[] byArray3 = null;
            ObjectDirectory objectDirectory = new ObjectDirectory();
            objectDirectory.selectAndRead(cardChannel);
            DNIeCIOCertificateDirectory dNIeCIOCertificateDirectory = new DNIeCIOCertificateDirectory(objectDirectory.getCDReferences().get(0));
            try {
                dNIeCIOCertificateDirectory.selectAndRead(cardChannel);
            }
            catch (IOException iOException) {
                throw new CardException("Error retrieving certificate path. ", iOException);
            }
            for (CIOCertificate cIOCertificate : dNIeCIOCertificateDirectory.getCIOs()) {
                String string = cIOCertificate.getLabel();
                if (string == null || !string.toLowerCase().contains("CertFirmaDigital".toLowerCase())) continue;
                byArray3 = cIOCertificate.getEfidOrPath();
            }
            if (byArray3 == null) {
                throw new NotActivatedException();
            }
            if (byArray3.length != 4) {
                throw new CardException("Unable to determine valid certificate path. Cert path has unexpected length.");
            }
            byArray2 = byArray3;
            this.verifyPINLoop(cardChannel, this.pinInfo, pINGUI);
            this.executeSelectMasterFile(cardChannel);
            this.executeSelect(cardChannel, new byte[]{byArray2[0], byArray2[1]});
            Object object = this.executeSelect(cardChannel, new byte[]{byArray2[2], byArray2[3]});
            Object object2 = object[7];
            Object object3 = object[8];
            byte[] byArray4 = this.executeReadBinary(cardChannel, (byte)object2, (byte)object3);
            byte[] byArray5 = new byte[byArray4.length - 8];
            System.arraycopy(byArray4, 8, byArray5, 0, byArray5.length);
            byArray = this.decompressData(byArray5);
        }
        catch (CardException cardException) {
            this.log.error("Error reading certificate from card.", cardException);
            throw new SignatureCardException("Error reading certificate from card.", cardException);
        }
        return byArray;
    }

    @Override
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        this.log.debug("Attempting to read infobox from DNIe..");
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    protected void verifyPINLoop(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI) throws LockedException, NotActivatedException, SignatureCardException, InterruptedException, CardException {
        int n = -1;
        while ((n = this.verifyPIN(cardChannel, pinInfo, pINGUI, n)) > 0) {
        }
    }

    protected int verifyPIN(CardChannel cardChannel, PinInfo pinInfo, PINGUI pINGUI, int n) throws SignatureCardException, LockedException, NotActivatedException, InterruptedException, CardException {
        char[] cArray = pINGUI.providePIN(pinInfo, n);
        byte[] byArray = new byte[5 + cArray.length];
        byArray[0] = 0;
        byArray[1] = 32;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = (byte)cArray.length;
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i + 5] = (byte)cArray[i];
        }
        ResponseAPDU responseAPDU = cardChannel.transmit(new CommandAPDU(byArray));
        int n2 = responseAPDU.getSW();
        if (n2 == 36864) {
            return -1;
        }
        if (n2 >> 4 == 1596) {
            return 0xF & n2;
        }
        switch (n2) {
            case 27011: {
                throw new LockedException();
            }
        }
        String string = "VERIFY failed. SW=" + Integer.toHexString(n2);
        this.log.info(string);
        throw new SignatureCardException(string);
    }

    private void executeSelectMasterFile(CardChannel cardChannel) throws CardException {
        byte[] byArray = new byte[MASTER_FILE_ID.length + 5];
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 4;
        byArray[3] = 0;
        byArray[4] = (byte)MASTER_FILE_ID.length;
        System.arraycopy(MASTER_FILE_ID, 0, byArray, 5, MASTER_FILE_ID.length);
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error selecting master file: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Error selecting master file: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void executeSelectDFCIA(CardChannel cardChannel) throws CardException {
        this.executeSelect(cardChannel, new byte[]{80, 21});
    }

    private byte[] executeSelect(CardChannel cardChannel, byte[] byArray) throws CardException {
        byte[] byArray2 = new byte[]{0, -92, 0, 0, (byte)byArray.length};
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        CommandAPDU commandAPDU = new CommandAPDU(byArray3);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("error selecting file " + SMCCHelper.toString(byArray) + ": " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Error selecting file " + SMCCHelper.toString(byArray) + ": " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private byte[] executeReadBinary(CardChannel cardChannel, byte by, byte by2) throws CardException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = by * 256 + by2;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (!bl) {
            n4 = n - n2 > 239 ? 239 : n - n2;
            byte[] byArray = SMCCHelper.toByteArray(n3);
            ResponseAPDU responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)n4);
            if (responseAPDU.getSW1() == 108) {
                responseAPDU = this.readFromCard(cardChannel, byArray[0], byArray[1], (byte)responseAPDU.getSW2());
                bl = true;
            }
            try {
                byteArrayOutputStream.write(responseAPDU.getData());
            }
            catch (IOException iOException) {
                this.log.error("Error executing secure read binary.", iOException);
                throw new CardException("Error reading data from card", iOException);
            }
            n3 = n2 += responseAPDU.getData().length;
            if (n2 != n) continue;
            bl = true;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void executeManageSecurityEnvironment(CardChannel cardChannel, byte[] byArray) throws CardException {
        byte[] byArray2 = new byte[]{0, 34, 65, -74, 4, -124, 2, byArray[0], byArray[1]};
        CommandAPDU commandAPDU = new CommandAPDU(byArray2);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error executing Manage Security Environment: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Execution of command Manage Security Environment failed: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private byte[] executeCreateSignature(CardChannel cardChannel, byte[] byArray) throws CardException {
        byte[] byArray2 = new byte[5 + this.HASH_PADDING.length + byArray.length + 1];
        byArray2[0] = 0;
        byArray2[1] = 42;
        byArray2[2] = -98;
        byArray2[3] = -102;
        byArray2[4] = (byte)(this.HASH_PADDING.length + byArray.length);
        System.arraycopy(this.HASH_PADDING, 0, byArray2, 5, this.HASH_PADDING.length);
        System.arraycopy(byArray, 0, byArray2, 5 + this.HASH_PADDING.length, byArray.length);
        byArray2[byArray2.length - 1] = -128;
        CommandAPDU commandAPDU = new CommandAPDU(byArray2);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error computing electronic signature on card: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Unexpected response from card: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private ResponseAPDU readFromCard(CardChannel cardChannel, byte by, byte by2, byte by3) throws CardException {
        byte[] byArray = new byte[]{0, -80, by, by2, by3};
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = cardChannel.transmit(commandAPDU);
        return responseAPDU;
    }

    private byte[] decompressData(byte[] byArray) throws CardException {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[256];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (!inflater.finished()) {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflater.end();
        }
        catch (DataFormatException dataFormatException) {
            throw new CardException("Error decompressing file.", dataFormatException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

