/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.DNIeCryptoUtil;
import at.gv.egiz.smcc.ESDNIeCard;
import at.gv.egiz.smcc.T0CardChannel;
import at.gv.egiz.smcc.util.SMCCHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNIeSecuredChannel
extends T0CardChannel {
    private static final String ROOT_CA_MODULO = "EADEDA455332945039DAA404C8EBC4D3B7F5DC869283CDEA2F101E2AB54FB0D0B03D8F030DAF2458028288F54CE552F8FA57AB2FB103B112427E11131D1D27E10A5B500EAAE5D940301E30EB26C3E9066B257156ED639D70CCC090B863AFBB3BFED8C17BE7673034B9823E977ED657252927F9575B9FFF6691DB64F80B5E92CD";
    private static final String ROOT_CA_PUBEXP = "010001";
    private final String TERMINAL_MODULO = "DB2CB41E112BACFA2BD7C3D3D7967E84FB9434FC261F9D090A8983947DAF8488D3DF8FBDCC1F92493585E134A1B42DE519F463244D7ED384E26D516CC7A4FF7895B1992140043AACADFC12E856B202346AF8226B1A882137DC3C5A57F0D2815C1FCD4BB46FA9157FDFFD79EC3A10A824CCC1EB3CE0B6B4396AE236590016BA69";
    private final String TERMINAL_PRIVEXP = "18B44A3D155C61EBF4E3261C8BB157E36F63FE30E9AF28892B59E2ADEB18CC8C8BAD284B9165819CA4DEC94AA06B69BCE81706D1C1B668EB128695E5F7FEDE18A908A3011A646A481D3EA71D8A387D474609BD57A882B182E047DE80E04B4221416BD39DFA1FAC0300641962ADB109E28CAF50061B68C9CABD9B00313C0F46ED";
    private final byte[] C_CV_CA = new byte[]{127, 33, -127, -50, 95, 55, -127, -128, 60, -70, -36, 54, -124, -66, -13, 32, 65, -83, 21, 80, -119, 37, -115, -3, 32, -58, -111, 21, -41, 47, -100, 56, -86, -103, -83, 108, 26, -19, -6, -78, -65, -84, -112, -110, -4, 112, -52, -64, 12, -81, 72, 42, 75, -29, 26, -3, -67, 60, -68, -116, -125, -126, -49, 6, -68, 7, 25, -70, -85, -75, 107, 110, -56, 7, 96, -92, -87, 63, -94, -41, -61, 71, -13, 68, 39, -7, -1, 92, -115, -26, -42, 93, -84, -107, -14, -15, -99, -84, 0, 83, -33, 17, -91, 7, -5, 98, 94, -21, -115, -92, -64, 41, -98, 74, 33, 18, -85, 112, 71, 88, -117, -115, 109, -89, 89, 34, 20, -14, -37, -95, 64, -57, -47, 34, 87, -101, 95, 56, 61, 34, 83, -56, -71, -53, 91, -61, 84, 58, 85, 102, 11, -38, -128, -108, 106, -5, 5, 37, -24, -27, 88, 107, 78, 99, -24, -110, 65, 73, 120, 54, -40, -45, -85, 8, -116, -44, 76, 33, 77, 106, -56, 86, -30, -96, 7, -12, 79, -125, 116, 51, 55, 55, 26, -35, -114, 3, 0, 1, 0, 1, 66, 8, 101, 115, 82, 68, 73, 96, 0, 6};
    private final byte[] CHR = new byte[]{-125, 8, 101, 115, 83, 68, 73, 96, 0, 6};
    private final byte[] KEY_SELECTOR = new byte[]{-125, 12, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 1, -124, 2, 2, 31};
    private final byte[] C_CV_IFD = new byte[]{127, 33, -127, -51, 95, 55, -127, -128, -126, 91, 105, -58, 69, 30, 95, 81, 112, 116, 56, 95, 47, 23, -42, 77, -2, 46, 104, 86, 117, 103, 9, 75, 87, -13, -59, 120, -24, 48, -28, 37, 87, 45, -24, 40, -6, -12, -34, 27, 1, -61, -108, -29, 69, -62, -5, 6, 41, -93, -109, 73, 47, -108, -11, 112, -80, 11, 29, 103, 119, 41, -9, 85, -47, 7, 2, 43, -80, -95, 22, -31, -41, -41, 101, -99, -75, -60, -84, 13, -34, -85, 7, -1, 4, 95, 55, -75, -38, -15, 115, 43, 84, -22, -78, 56, -94, -50, 23, -55, 121, 65, -121, 117, -100, -22, -97, -110, -95, 120, 5, -94, 124, 16, 21, -20, 86, -52, 126, 71, 26, 72, -114, 111, 27, -111, -9, -86, 95, 56, 60, -83, -4, 18, -24, 86, -78, 2, 52, 106, -8, 34, 107, 26, -120, 33, 55, -36, 60, 90, 87, -16, -46, -127, 92, 31, -51, 75, -76, 111, -87, 21, 127, -33, -3, 121, -20, 58, 16, -88, 36, -52, -63, -21, 60, -32, -74, -76, 57, 106, -30, 54, 89, 0, 22, -70, 105, 0, 1, 0, 1, 66, 8, 101, 115, 83, 68, 73, 96, 0, 6};
    private final byte[] APDU_GET_CHIP_INFO = new byte[]{-112, -72, 0, 0, 7};
    private final byte[] SECURE_CHANNEL_COMP_CERT_ID = new byte[]{96, 31};
    private final byte[] SECURE_CHANNEL_INTERMEDIAT_CERT_ID = new byte[]{96, 32};
    private final byte[] TERMINAL_CHALLENGE_TAIL = new byte[]{32, 0, 0, 0, 0, 0, 0, 1};
    private final byte[] KENC_COMPUTATION_TAIL = new byte[]{0, 0, 0, 1};
    private final byte[] KMAC_COMPUTATION_TAIL = new byte[]{0, 0, 0, 2};
    private final int BLOCK_LENGTH = 8;
    private final Logger log = LoggerFactory.getLogger(DNIeSecuredChannel.class);
    private byte[] snIcc;
    private byte[] componentCert;
    private byte[] intermediateCert;
    private byte[] rndIfd;
    private byte[] rndIcc;
    private int prndLength;
    private byte[] kicc;
    private byte[] kifd;
    private byte[] kEnc;
    private byte[] kMac;
    private byte[] ssc;
    private boolean established = false;

    public DNIeSecuredChannel(CardChannel cardChannel) {
        super(cardChannel);
        try {
            this.establish();
        }
        catch (CardException cardException) {
            this.log.error("Error establishing secure channel with card.", cardException);
        }
    }

    public void establish() throws CardException {
        this.log.trace("Try to set up secure channel to card..");
        this.executeSelectMasterFile();
        this.snIcc = this.executeGetChipInfo();
        this.intermediateCert = this.executeReadCardCertificate(this.SECURE_CHANNEL_INTERMEDIAT_CERT_ID);
        this.componentCert = this.executeReadCardCertificate(this.SECURE_CHANNEL_COMP_CERT_ID);
        this.verifyCertificates();
        this.loadTerminalCertsAndSelectKeys();
        this.performInternalAuthentication();
        this.performExternalAuthentication();
        this.calculateChannelKeys();
        this.established = true;
        this.log.trace("Secure channel successfully established.");
    }

    @Override
    public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws CardException {
        byte[] byArray = new byte[byteBuffer.remaining()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byteBuffer.get();
        }
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = this.transmit(commandAPDU);
        byte[] byArray2 = responseAPDU.getBytes();
        for (int i = 0; i < byArray2.length; ++i) {
            byteBuffer2.put(byArray2[i]);
        }
        return byArray2.length;
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardException {
        if (!this.established) {
            this.establish();
        }
        byte[] byArray = commandAPDU.getBytes();
        byte[] byArray2 = this.secureAPDU(byArray);
        CommandAPDU commandAPDU2 = new CommandAPDU(byArray2);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU2);
        byte[] byArray3 = this.verifyAndDecryptSecuredResponseAPDU(responseAPDU.getData());
        ResponseAPDU responseAPDU2 = new ResponseAPDU(byArray3);
        return responseAPDU2;
    }

    private byte[] executeGetChipInfo() throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(this.APDU_GET_CHIP_INFO);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error getting chip info: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Error getting chip info: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private byte[] executeReadCardCertificate(byte[] byArray) throws CardException {
        byte[] byArray2 = this.executeSelect(byArray);
        if (byArray2 == null || byArray2.length < 7) {
            this.log.error("Error reading card certificate: Invalid FCI");
            throw new CardException("Invalid FCI obtained from card.");
        }
        byte by = byArray2[7];
        byte by2 = byArray2[8];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = by * 256 + by2;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (!bl) {
            n4 = n - n2 > 255 ? 255 : n - n2;
            byte[] byArray3 = SMCCHelper.toByteArray(n3);
            byte[] byArray4 = new byte[]{0, -80, byArray3[0], byArray3[1], (byte)n4};
            CommandAPDU commandAPDU = new CommandAPDU(byArray4);
            ResponseAPDU responseAPDU = super.transmit(commandAPDU);
            byte[] byArray5 = responseAPDU.getData();
            try {
                byteArrayOutputStream.write(byArray5);
            }
            catch (IOException iOException) {
                this.log.error("Error reading card certificate.", iOException);
                throw new CardException("Error reading certificate from card", iOException);
            }
            n3 = n2 += byArray5.length;
            if (n2 != n) continue;
            bl = true;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] executeSelect(byte[] byArray) throws CardException {
        byte[] byArray2 = new byte[]{0, -92, 0, 0};
        byte[] byArray3 = new byte[byArray2.length + 1 + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byArray3[byArray2.length] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, byArray2.length + 1, byArray.length);
        CommandAPDU commandAPDU = new CommandAPDU(byArray3);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error selecting DF or EF: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Unexpected response to Select Command: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private void executeSelectMasterFile() throws CardException {
        byte[] byArray = new byte[ESDNIeCard.MASTER_FILE_ID.length + 5];
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 4;
        byArray[3] = 0;
        byArray[4] = (byte)ESDNIeCard.MASTER_FILE_ID.length;
        System.arraycopy(ESDNIeCard.MASTER_FILE_ID, 0, byArray, 5, ESDNIeCard.MASTER_FILE_ID.length);
        CommandAPDU commandAPDU = new CommandAPDU(byArray);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error selecting master file: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Error selecting master file: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void verifyCertificates() throws CardException {
        RSAPublicKey rSAPublicKey = DNIeCryptoUtil.createRSAPublicKey(ROOT_CA_MODULO, ROOT_CA_PUBEXP);
        X509Certificate x509Certificate = DNIeCryptoUtil.createCertificate(this.intermediateCert);
        X509Certificate x509Certificate2 = DNIeCryptoUtil.createCertificate(this.componentCert);
        try {
            x509Certificate2.verify(x509Certificate.getPublicKey());
            x509Certificate.verify(rSAPublicKey);
        }
        catch (Exception exception) {
            this.log.error("Error verifying SM card certificate.", exception);
            throw new CardException("Certificate verification failed.", exception);
        }
    }

    private void loadTerminalCertsAndSelectKeys() throws CardException {
        this.executeManageSecurityEnvironment((byte)-127, (byte)-74, new byte[]{-125, 2, 2, 15});
        this.executePerformSecurityOperation(this.C_CV_CA);
        this.executeManageSecurityEnvironment((byte)-127, (byte)-74, this.CHR);
        this.executePerformSecurityOperation(this.C_CV_IFD);
        this.executeManageSecurityEnvironment((byte)-63, (byte)-92, this.KEY_SELECTOR);
    }

    private void executeManageSecurityEnvironment(byte by, byte by2, byte[] byArray) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 34, (int)by, (int)by2, byArray);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error executing Manage Security Environment: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Unexpected response from card during preparation of secure channel credentials: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void executePerformSecurityOperation(byte[] byArray) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 42, 0, -82, byArray);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error executing Perform Security Operation: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Unexpected response from card during preparation of secure channel credentials: " + Integer.toHexString(responseAPDU.getSW()));
        }
    }

    private void performInternalAuthentication() throws CardException {
        this.log.trace("Starting internal authentication..");
        byte[] byArray = DNIeCryptoUtil.getRandomBytes(8);
        byte[] byArray2 = new byte[byArray.length + this.TERMINAL_CHALLENGE_TAIL.length];
        this.rndIfd = byArray;
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(this.TERMINAL_CHALLENGE_TAIL, 0, byArray2, byArray.length, this.TERMINAL_CHALLENGE_TAIL.length);
        byte[] byArray3 = this.executeSendTerminalChallenge(byArray2);
        boolean bl = this.verifyCardResponse(byArray3);
        this.log.trace("Internal Authentiction succeeded: " + bl);
        if (!bl) {
            this.log.error("Internal authentication failed - unable to sucessfully verify card response.");
            throw new CardException("Internal authentication failed");
        }
    }

    private byte[] executeSendTerminalChallenge(byte[] byArray) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -120, 0, 0, byArray);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        byte[] byArray2 = null;
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error sending terminal challenge to card: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Invalid response to terminal challenge: " + Integer.toHexString(responseAPDU.getSW()));
        }
        byArray2 = responseAPDU.getData();
        return byArray2;
    }

    private boolean verifyCardResponse(byte[] byArray) throws CardException {
        byte[] byArray2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        byte[] byArray3 = this.rndIfd;
        byte[] byArray4 = byArray;
        byte[] byArray5 = null;
        RSAPrivateKey rSAPrivateKey = DNIeCryptoUtil.createRSAPrivateKey("DB2CB41E112BACFA2BD7C3D3D7967E84FB9434FC261F9D090A8983947DAF8488D3DF8FBDCC1F92493585E134A1B42DE519F463244D7ED384E26D516CC7A4FF7895B1992140043AACADFC12E856B202346AF8226B1A882137DC3C5A57F0D2815C1FCD4BB46FA9157FDFFD79EC3A10A824CCC1EB3CE0B6B4396AE236590016BA69", "18B44A3D155C61EBF4E3261C8BB157E36F63FE30E9AF28892B59E2ADEB18CC8C8BAD284B9165819CA4DEC94AA06B69BCE81706D1C1B668EB128695E5F7FEDE18A908A3011A646A481D3EA71D8A387D474609BD57A882B182E047DE80E04B4221416BD39DFA1FAC0300641962ADB109E28CAF50061B68C9CABD9B00313C0F46ED");
        try {
            byArray5 = DNIeCryptoUtil.rsaDecrypt(rSAPrivateKey, byArray4);
        }
        catch (Exception exception) {
            this.log.error("Error verifying card response.");
            throw new CardException("Error decrypting card response.", exception);
        }
        X509Certificate x509Certificate = DNIeCryptoUtil.createCertificate(this.componentCert);
        PublicKey publicKey = x509Certificate.getPublicKey();
        byte[] byArray6 = null;
        try {
            byArray6 = DNIeCryptoUtil.rsaDecrypt(publicKey, byArray5);
        }
        catch (Exception exception) {
            this.log.error("Error verifying card response.", exception);
            throw new CardException("Error decrypting card response with card's public key", exception);
        }
        if (byArray6 == null) {
            this.log.error("Error verifying card response - decryption result is null");
            throw new CardException("Invalid decryption result: null.");
        }
        if (byArray6[0] != 106 || byArray6[byArray6.length - 1] != -68) {
            object4 = (RSAPublicKey)publicKey;
            object3 = object4.getModulus();
            object2 = SMCCHelper.createUnsignedBigInteger(byArray5);
            object = ((BigInteger)object3).subtract((BigInteger)object2);
            byArray2 = ((BigInteger)object).toByteArray();
            byte[] byArray7 = new byte[128];
            System.arraycopy(byArray2, byArray2.length - 128, byArray7, 0, 128);
            try {
                byArray6 = DNIeCryptoUtil.rsaDecrypt(publicKey, byArray7);
            }
            catch (Exception exception) {
                this.log.error("Error verifying card response.", exception);
                throw new CardException("Error decrypting card response.", exception);
            }
        }
        object4 = new byte[20];
        object3 = new byte[32];
        object2 = new byte[byArray6.length - 2 - 20 - 32];
        this.prndLength = ((Object)object2).length;
        System.arraycopy(byArray6, 1, object2, 0, ((Object)object2).length);
        System.arraycopy(byArray6, ((Object)object2).length + 1, object3, 0, ((Object)object3).length);
        System.arraycopy(byArray6, ((Object)object2).length + ((Object)object3).length + 1, object4, 0, ((Object)object4).length);
        object = new byte[((Object)object2).length + ((Object)object3).length + byArray3.length + this.TERMINAL_CHALLENGE_TAIL.length];
        System.arraycopy(object2, 0, object, 0, ((Object)object2).length);
        System.arraycopy(object3, 0, object, ((Object)object2).length, ((Object)object3).length);
        System.arraycopy(byArray3, 0, object, ((Object)object2).length + ((Object)object3).length, byArray3.length);
        System.arraycopy(this.TERMINAL_CHALLENGE_TAIL, 0, object, ((Object)object2).length + ((Object)object3).length + byArray3.length, this.TERMINAL_CHALLENGE_TAIL.length);
        byArray2 = DNIeCryptoUtil.computeSHA1Hash((byte[])object);
        boolean bl = Arrays.equals((byte[])object4, byArray2);
        if (bl) {
            this.kicc = (byte[])object3;
        }
        return bl;
    }

    private void performExternalAuthentication() throws CardException {
        this.log.trace("Performing external authentication.");
        byte[] byArray = this.executeRequestCardChallenge();
        this.rndIcc = byArray;
        byte[] byArray2 = DNIeCryptoUtil.getRandomBytes(this.prndLength);
        byte[] byArray3 = DNIeCryptoUtil.getRandomBytes(32);
        byte[] byArray4 = new byte[byArray2.length + byArray3.length + byArray.length + 8];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray2.length + byArray3.length, byArray.length);
        int n = 8 - this.snIcc.length;
        for (int i = 0; i < n; ++i) {
            byArray4[byArray2.length + byArray3.length + byArray.length + i] = 0;
        }
        System.arraycopy(this.snIcc, 0, byArray4, byArray2.length + byArray3.length + byArray.length + n, this.snIcc.length);
        byte[] byArray5 = DNIeCryptoUtil.computeSHA1Hash(byArray4);
        byte[] byArray6 = new byte[2 + byArray2.length + byArray3.length + byArray5.length];
        byArray6[0] = 106;
        System.arraycopy(byArray2, 0, byArray6, 1, byArray2.length);
        System.arraycopy(byArray3, 0, byArray6, 1 + byArray2.length, byArray3.length);
        System.arraycopy(byArray5, 0, byArray6, 1 + byArray2.length + byArray3.length, byArray5.length);
        byArray6[byArray6.length - 1] = -68;
        RSAPrivateKey rSAPrivateKey = DNIeCryptoUtil.createRSAPrivateKey("DB2CB41E112BACFA2BD7C3D3D7967E84FB9434FC261F9D090A8983947DAF8488D3DF8FBDCC1F92493585E134A1B42DE519F463244D7ED384E26D516CC7A4FF7895B1992140043AACADFC12E856B202346AF8226B1A882137DC3C5A57F0D2815C1FCD4BB46FA9157FDFFD79EC3A10A824CCC1EB3CE0B6B4396AE236590016BA69", "18B44A3D155C61EBF4E3261C8BB157E36F63FE30E9AF28892B59E2ADEB18CC8C8BAD284B9165819CA4DEC94AA06B69BCE81706D1C1B668EB128695E5F7FEDE18A908A3011A646A481D3EA71D8A387D474609BD57A882B182E047DE80E04B4221416BD39DFA1FAC0300641962ADB109E28CAF50061B68C9CABD9B00313C0F46ED");
        byte[] byArray7 = null;
        try {
            byArray7 = DNIeCryptoUtil.rsaEncrypt(rSAPrivateKey, byArray6);
        }
        catch (Exception exception) {
            this.log.error("Error performing external authentication.", exception);
            throw new CardException("Error encrypting authentication data.", exception);
        }
        BigInteger bigInteger = SMCCHelper.createUnsignedBigInteger(byArray7);
        BigInteger bigInteger2 = new BigInteger("DB2CB41E112BACFA2BD7C3D3D7967E84FB9434FC261F9D090A8983947DAF8488D3DF8FBDCC1F92493585E134A1B42DE519F463244D7ED384E26D516CC7A4FF7895B1992140043AACADFC12E856B202346AF8226B1A882137DC3C5A57F0D2815C1FCD4BB46FA9157FDFFD79EC3A10A824CCC1EB3CE0B6B4396AE236590016BA69", 16);
        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
        BigInteger bigInteger4 = bigInteger3.min(bigInteger);
        PublicKey publicKey = null;
        X509Certificate x509Certificate = DNIeCryptoUtil.createCertificate(this.componentCert);
        publicKey = x509Certificate.getPublicKey();
        byte[] byArray8 = null;
        try {
            byArray8 = DNIeCryptoUtil.rsaEncrypt(publicKey, bigInteger4.toByteArray());
        }
        catch (Exception exception) {
            this.log.error("Error performing external authentication.", exception);
            throw new CardException("Error encrypting authentication data.", exception);
        }
        if (!this.executeExternalAuthenticate(byArray8)) {
            this.log.error("Error performing external authentication");
            throw new CardException("External Authentication failed.");
        }
        this.log.trace("External authentication succeeded.");
        this.kifd = byArray3;
    }

    private byte[] executeRequestCardChallenge() throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -124, 0, 0, 8);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        if (responseAPDU.getSW() != 36864) {
            this.log.error("Error requesting challenge from card: " + Integer.toHexString(responseAPDU.getSW()));
            throw new CardException("Invalid response from card upon challenge request: " + Integer.toHexString(responseAPDU.getSW()));
        }
        return responseAPDU.getData();
    }

    private boolean executeExternalAuthenticate(byte[] byArray) throws CardException {
        CommandAPDU commandAPDU = new CommandAPDU(0, -126, 0, 0, byArray);
        ResponseAPDU responseAPDU = super.transmit(commandAPDU);
        this.log.trace("Card answer to EXTERNL AUTHENTICATE: " + Integer.toHexString(responseAPDU.getSW()));
        return responseAPDU.getSW() == 36864;
    }

    private void calculateChannelKeys() throws CardException {
        if (this.kicc == null || this.kifd == null) {
            this.log.error("Error generating channel keys - required key data is null.");
            throw new CardException("Required data for deriving keys not available.");
        }
        if (this.kicc.length != this.kifd.length) {
            this.log.error("Error generating channel keys - invalid key data");
            throw new CardException("Required data for deriving keys is invalid.");
        }
        byte[] byArray = new byte[this.kicc.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(this.kicc[i] ^ this.kifd[i]);
        }
        byte[] byArray2 = new byte[byArray.length + this.KENC_COMPUTATION_TAIL.length];
        byte[] byArray3 = new byte[byArray.length + this.KMAC_COMPUTATION_TAIL.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(this.KENC_COMPUTATION_TAIL, 0, byArray2, byArray.length, this.KENC_COMPUTATION_TAIL.length);
        System.arraycopy(this.KMAC_COMPUTATION_TAIL, 0, byArray3, byArray.length, this.KMAC_COMPUTATION_TAIL.length);
        byte[] byArray4 = DNIeCryptoUtil.computeSHA1Hash(byArray2);
        byte[] byArray5 = DNIeCryptoUtil.computeSHA1Hash(byArray3);
        this.kEnc = Arrays.copyOfRange(byArray4, 0, 16);
        this.kMac = Arrays.copyOfRange(byArray5, 0, 16);
        if (this.rndIcc == null || this.rndIfd == null || this.rndIcc.length < 4 || this.rndIfd.length < 4) {
            this.log.error("Error generating channel keys - invlaid ssc data");
            throw new CardException("Data required to compute SSC not valid.");
        }
        this.ssc = new byte[8];
        System.arraycopy(this.rndIcc, this.rndIcc.length - 4, this.ssc, 0, 4);
        System.arraycopy(this.rndIfd, this.rndIfd.length - 4, this.ssc, 4, 4);
    }

    private byte[] secureAPDUWithoutData(byte[] byArray) throws CardException {
        int n;
        if (byArray.length < 4 || byArray.length > 5) {
            this.log.error("Error securing APDU - invalid APDU length: " + byArray.length);
            throw new CardException("Invalid APDU length.");
        }
        boolean bl = byArray.length == 5;
        byte by = (byte)(byArray[0] | 0xC);
        byte[] byArray2 = new byte[]{by, byArray[1], byArray[2], byArray[3]};
        byte[] byArray3 = DNIeCryptoUtil.applyPadding(8, byArray2);
        byte[] byArray4 = null;
        if (bl) {
            byArray4 = new byte[]{-105, 1, byArray[4]};
            n = byArray4.length;
        } else {
            n = 0;
        }
        byte[] byArray5 = new byte[byArray3.length + n];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        if (bl) {
            System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
            byArray5 = DNIeCryptoUtil.applyPadding(8, byArray5);
        }
        this.incrementSSC();
        byte[] byArray6 = DNIeCryptoUtil.calculateAPDUMAC(byArray5, this.kMac, this.ssc, 8);
        byte[] byArray7 = new byte[byArray6.length + 2];
        byArray7[0] = -114;
        byArray7[1] = (byte)byArray6.length;
        System.arraycopy(byArray6, 0, byArray7, 2, byArray6.length);
        byte[] byArray8 = new byte[5 + n + byArray7.length];
        byArray8[0] = by;
        byArray8[1] = byArray[1];
        byArray8[2] = byArray[2];
        byArray8[3] = byArray[3];
        byArray8[4] = (byte)(byArray7.length + n);
        if (bl) {
            System.arraycopy(byArray4, 0, byArray8, 5, byArray4.length);
        }
        System.arraycopy(byArray7, 0, byArray8, 5 + n, byArray7.length);
        return byArray8;
    }

    private byte[] secureAPDUWithData(byte[] byArray) throws CardException {
        byte[] byArray2;
        boolean bl;
        if (byArray.length < 6) {
            this.log.error("Error securing APDU - invalid APDU length: " + byArray.length);
            throw new CardException("Error securing APDU - invalid APDU length: " + byArray.length);
        }
        byte by = byArray[0];
        byte by2 = byArray[1];
        byte by3 = byArray[2];
        byte by4 = byArray[3];
        byte by5 = byArray[4];
        if (byArray.length == by5 + 5 + 1) {
            bl = true;
        } else {
            if (byArray.length != by5 + 5) {
                this.log.error("Error securing APDU - invalid APDU length: " + byArray.length);
                throw new CardException("Invalid APDU length or format.");
            }
            bl = false;
        }
        byte[] byArray3 = null;
        if (bl) {
            byte by6 = byArray[byArray.length - 1];
            byArray3 = new byte[]{-105, 1, by6};
        }
        byte[] byArray4 = new byte[by5];
        System.arraycopy(byArray, 5, byArray4, 0, by5);
        byte[] byArray5 = DNIeCryptoUtil.applyPadding(8, byArray4);
        byte[] byArray6 = null;
        try {
            byArray6 = DNIeCryptoUtil.perform3DESCipherOperation(byArray5, this.kEnc, 1);
        }
        catch (Exception exception) {
            this.log.error("Error encrypting APDU.", exception);
            throw new CardException("Error encrypting APDU.", exception);
        }
        byte[] byArray7 = new byte[byArray6.length + 3];
        byArray7[0] = -121;
        byArray7[1] = (byte)(byArray6.length + 1);
        byArray7[2] = 1;
        System.arraycopy(byArray6, 0, byArray7, 3, byArray6.length);
        byte by7 = (byte)(by | 0xC);
        byte[] byArray8 = new byte[]{by7, by2, by3, by4};
        byte[] byArray9 = DNIeCryptoUtil.applyPadding(8, byArray8);
        byte[] byArray10 = new byte[byArray9.length + byArray7.length];
        System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
        System.arraycopy(byArray7, 0, byArray10, byArray9.length, byArray7.length);
        if (bl) {
            byArray2 = new byte[byArray10.length + byArray3.length];
            System.arraycopy(byArray10, 0, byArray2, 0, byArray10.length);
            System.arraycopy(byArray3, 0, byArray2, byArray10.length, byArray3.length);
            byArray10 = byArray2;
        }
        byArray2 = DNIeCryptoUtil.applyPadding(8, byArray10);
        this.incrementSSC();
        byte[] byArray11 = DNIeCryptoUtil.calculateAPDUMAC(byArray2, this.kMac, this.ssc, 8);
        byte[] byArray12 = new byte[byArray11.length + 2];
        byArray12[0] = -114;
        byArray12[1] = (byte)byArray11.length;
        System.arraycopy(byArray11, 0, byArray12, 2, byArray11.length);
        int n = bl ? byArray3.length : 0;
        byte[] byArray13 = new byte[5 + byArray7.length + byArray12.length + n];
        byArray13[0] = by7;
        byArray13[1] = by2;
        byArray13[2] = by3;
        byArray13[3] = by4;
        byArray13[4] = (byte)(byArray7.length + n + byArray12.length);
        System.arraycopy(byArray7, 0, byArray13, 5, byArray7.length);
        if (bl) {
            System.arraycopy(byArray3, 0, byArray13, 5 + byArray7.length, n);
        }
        System.arraycopy(byArray12, 0, byArray13, 5 + byArray7.length + n, byArray12.length);
        return byArray13;
    }

    private byte[] secureAPDU(byte[] byArray) throws CardException {
        if (byArray == null || byArray.length < 4) {
            this.log.error("Invalid APDU to secure.");
            throw new CardException("Invalid APDU to secure.");
        }
        if (byArray.length == 4 || byArray.length == 5) {
            return this.secureAPDUWithoutData(byArray);
        }
        if (byArray.length > 5) {
            return this.secureAPDUWithData(byArray);
        }
        throw new CardException("Error securing APDU - unexpected APDU length.");
    }

    private byte[] verifyAndDecryptSecuredResponseAPDU(byte[] byArray) throws CardException {
        byte[] byArray2 = new byte[byArray.length - 10];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
        System.arraycopy(byArray, byArray2.length + byArray3.length + 2, byArray4, 0, byArray4.length);
        byte[] byArray5 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, byArray2.length, byArray3.length);
        byte[] byArray6 = DNIeCryptoUtil.applyPadding(8, byArray5);
        this.incrementSSC();
        byte[] byArray7 = DNIeCryptoUtil.calculateAPDUMAC(byArray6, this.kMac, this.ssc, 8);
        if (!Arrays.equals(byArray7, byArray4)) {
            this.log.error("Error verifiying MAC of secured response. MAC values do not match.");
            throw new CardException("Unable to verify MAC of Response APDU.");
        }
        if (byArray2.length > 0) {
            byte[] byArray8 = new byte[byArray2.length - DNIeCryptoUtil.getCutOffLength(byArray2, 8)];
            System.arraycopy(byArray2, DNIeCryptoUtil.getCutOffLength(byArray2, 8), byArray8, 0, byArray8.length);
            byte[] byArray9 = null;
            try {
                byArray9 = DNIeCryptoUtil.perform3DESCipherOperation(byArray8, this.kEnc, 2);
            }
            catch (Exception exception) {
                this.log.error("Error decrypting data.", exception);
                throw new CardException("Unable to decrypt data.", exception);
            }
            byte[] byArray10 = DNIeCryptoUtil.removePadding(byArray9);
            byte[] byArray11 = new byte[byArray10.length + 2];
            System.arraycopy(byArray10, 0, byArray11, 0, byArray10.length);
            byArray11[byArray11.length - 2] = byArray3[2];
            byArray11[byArray11.length - 1] = byArray3[3];
            return byArray11;
        }
        byte[] byArray12 = new byte[2];
        byArray12[byArray12.length - 2] = byArray3[2];
        byArray12[byArray12.length - 1] = byArray3[3];
        return byArray12;
    }

    private void incrementSSC() {
        BigInteger bigInteger = new BigInteger(this.ssc);
        bigInteger = bigInteger.add(new BigInteger("1", 10));
        this.ssc = bigInteger.toByteArray();
    }
}

