/*
 * Decompiled with CFR 0.152.
 */
package at.gv.egiz.smcc;

import at.gv.egiz.smcc.ACOSCard;
import at.gv.egiz.smcc.AbstractACOSCardInfoboxHandler;
import at.gv.egiz.smcc.Exclusive;
import at.gv.egiz.smcc.FileNotFoundException;
import at.gv.egiz.smcc.Infobox;
import at.gv.egiz.smcc.InfoboxContainer;
import at.gv.egiz.smcc.NotActivatedException;
import at.gv.egiz.smcc.SecurityStatusNotSatisfiedException;
import at.gv.egiz.smcc.SignatureCardException;
import at.gv.egiz.smcc.pin.gui.PINGUI;
import at.gv.egiz.smcc.util.ISO7816Utils;
import at.gv.egiz.smcc.util.TransparentFileInputStream;
import java.io.IOException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACOSATCard
extends AbstractACOSCardInfoboxHandler {
    private final Logger log = LoggerFactory.getLogger(ACOSATCard.class);

    public ACOSATCard(ACOSCard aCOSCard) {
        super(aCOSCard);
    }

    @Override
    @Exclusive
    public byte[] getInfobox(String string, PINGUI pINGUI, String string2) throws SignatureCardException, InterruptedException {
        if ("IdentityLink".equals(string)) {
            if (this._acoscard.getAppVersion() < 2) {
                return this.getIdentityLinkV1(pINGUI, string2);
            }
            return this.getIdentityLinkV2(pINGUI, string2);
        }
        throw new IllegalArgumentException("Infobox '" + string + "' not supported.");
    }

    protected byte[] getIdentityLinkV1(PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException {
        try {
            CardChannel cardChannel = this._acoscard.getCardChannel();
            this._acoscard.execSELECT_AID(cardChannel, ACOSCard.AID_DEC);
            byte[] byArray = this._acoscard.execSELECT_FID(cardChannel, ACOSCard.EF_INFOBOX);
            int n = ISO7816Utils.getLengthFromFCx(byArray);
            this.log.debug("Size of selected file = {}.", (Object)n);
            while (true) {
                try {
                    byte[] byArray2 = ISO7816Utils.readTransparentFileTLV(cardChannel, n, (byte)48);
                    if (byArray2 != null) {
                        return byArray2;
                    }
                    throw new NotActivatedException();
                }
                catch (SecurityStatusNotSatisfiedException securityStatusNotSatisfiedException) {
                    this._acoscard.verifyPINLoop(cardChannel, this._acoscard.infPinInfo, pINGUI);
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Failed to get infobox.", cardException);
            throw new SignatureCardException(cardException);
        }
    }

    protected byte[] getIdentityLinkV2(PINGUI pINGUI, String string) throws SignatureCardException, InterruptedException {
        try {
            CardChannel cardChannel = this._acoscard.getCardChannel();
            this._acoscard.execSELECT_AID(cardChannel, ACOSCard.AID_DEC);
            this._acoscard.execSELECT_FID(cardChannel, ACOSCard.EF_INFOBOX);
            TransparentFileInputStream transparentFileInputStream = ISO7816Utils.openTransparentFileInputStream(cardChannel, -1);
            InfoboxContainer infoboxContainer = new InfoboxContainer(transparentFileInputStream, 48);
            for (Infobox infobox : infoboxContainer.getInfoboxes()) {
                if (infobox.getTag() != 1) continue;
                if (infobox.isEncrypted()) {
                    this._acoscard.execMSE(cardChannel, 65, 184, new byte[]{-124, 1, -120, -128, 1, 2});
                    byte[] byArray = null;
                    while (true) {
                        try {
                            byArray = this._acoscard.execPSO_DECIPHER(cardChannel, infobox.getEncryptedKey());
                        }
                        catch (SecurityStatusNotSatisfiedException securityStatusNotSatisfiedException) {
                            this._acoscard.verifyPINLoop(cardChannel, this._acoscard.decPinInfo, pINGUI);
                            continue;
                        }
                        break;
                    }
                    return infobox.decipher(byArray);
                }
                return infobox.getData();
            }
            throw new NotActivatedException();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NotActivatedException();
        }
        catch (CardException cardException) {
            this.log.info("Faild to get infobox.", cardException);
            throw new SignatureCardException(cardException);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof SignatureCardException) {
                throw (SignatureCardException)iOException.getCause();
            }
            throw new SignatureCardException(iOException);
        }
    }
}

